<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Devrabiul\ToastMagic\Facades\ToastMagic;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/dashboard';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }
    public function subadmin(){
        return view('auth.subadmin');
    }
    public function login(Request $request)
    {
        $request->validate([
            'source' => ['sometimes'],
            'role' => ['sometimes', 'in:manager,counselor,stl,tl,trainer,teacher'],
            'login_type' => ['required','in:id,phone'],
            'password' => 'required'
        ]);
        
        if (method_exists($this, 'hasTooManyLoginAttempts') &&
            $this->hasTooManyLoginAttempts($request)) {
            $this->fireLockoutEvent($request);

            return $this->sendLockoutResponse($request);
        }

        if($request->login_type == 'id'){
            $credentials = [
                'id' => $request->id,
                'password' => $request->password
            ];
        }else{
            $credentials = [
                'phone' => $request->phone,
                'password' => $request->password,
                'status' => 1
            ];
        }
        if($request->role){
            $credentials['role'] = $request->role;
        }

        if ($this->guard()->attempt($credentials, true)) {
            if ($request->hasSession()) {
                $request->session()->put('auth.password_confirmed_at', time());
            }

            if(!$request->source){
                $user = $request->user();
                if(!in_array($user->role, ['admin','student'])){
                    Auth::logout();
                    ToastMagic::error("Credentials does not match");
                    return redirect()->back();
                }
            }

            $request->session()->regenerate();
            $this->clearLoginAttempts($request);

            return redirect('/');
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);

        return throw ValidationException::withMessages([
            'id' => [trans('auth.failed')],
        ]);
    }
}
