<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\UserHierarchy;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Devrabiul\ToastMagic\Facades\ToastMagic;


class UserDataController extends Controller
{
    public function fetchStls($counselorId)
    {
        return response()->json(UserHierarchy::with('user:id,name')->where('counselor_id', $counselorId)->get(['id', 'user_id']));
    }
    public function fetchTls($stlId)
    {
        return response()->json(UserHierarchy::with('user:id,name')->where('senior_team_leader_id', $stlId)->get(['id', 'user_id']));
    }
    public function updateBalance(Request $request){
        $request->validate([
            'id' => 'required',
            'type' => 'required|in:credit,debit',
            'amount' => 'required|min:1|numeric',
            'details' => 'required'
        ]);

        try {
            DB::transaction(function() use($request){
                if($request->type == 'credit'){
                    credit_balance($request->id, $request->amount, $request->details);
                }else{
                    debit_balance($request->id, $request->amount, $request->details);
                }
            });
        } catch (\Throwable $th) {
            ToastMagic::error($th->getMessage());
            return redirect()->back();
        }

        ToastMagic::success("User balance has been updated");
        return redirect()->back();
    }
}
