<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\Withdrawal;
use Devrabiul\ToastMagic\Facades\ToastMagic;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WithdrawalController extends Controller
{
    public function index(Request $request){
        $query = Withdrawal::query()->with('user');

        if(!$request->status){
            $request->merge(['status' => 'pending']);
        }
        if ($request->status != 'all') {
            $query->where('status', $request->status);
        }

        $withdrawals = $query->latest()->paginate(25)->appends($request->query());
        // return $withdrawals;
        $statuses = ['all', 'pending', 'approved', 'declined'];
        return view('backend.withdrawals.index', ['statuses' => $statuses, 'withdrawals' => $withdrawals]);
    }

    public function update(Request $request){
        $request->validate([
            'id' => 'required',
            'status' => 'required|in:approved,declined'
        ]);

        DB::transaction(function() use($request){
            $withdrawal = Withdrawal::findOrFail($request->id);
            if($request->status == 'declined'){
                credit_balance($withdrawal->user_id, $withdrawal->amount, 'Withdrawal request rejected');
            }
            $withdrawal->status = $request->status;
            $withdrawal->save();
        });

        ToastMagic::success("Status has been updated");
        return redirect()->back();
    }
}
