<?php

namespace App\Http\Controllers;

use App\Models\ClassLink;
use App\Models\Course;
use Devrabiul\ToastMagic\Facades\ToastMagic;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Auth;

class ClassLinkController extends Controller
{
    public function __construct()
    {
        $this->middleware('role:student')->only(['joinClass']);
        $this->middleware('role:admin,trainer,teacher')->only(['index']);
    }

    public function index()
    {
        $user = Auth::user();
        $query = ClassLink::query();
        if ($user->role == 'admin') {
            $query->with('course:id,name', 'user:id,name,role');
            $data['links'] = $query->latest()->paginate(25);
            $data['courses'] = Course::where('work_submit', true)->latest()->get();
            return view('backend.class_links.index', $data);
        } else {
            $query->where('user_id', $user->id);
            $data['title'] = "Class Links";
            $data['links'] = $query->with('course:id,name')->latest()->paginate(25);
            $user->load(['trainer.course', 'teacher.course']);
            $data['course'] = $user->{$user->role}?->course;
            return view('trainer_teacher.class_links', $data);
        }
    }
    public function store(Request $request)
    {
        $user = $request->user();
        $request->validate([
            'course' => 'required',
            'link' => 'required',
            'time' => 'required',
        ]);

        $private = true;
        if($user->role == 'admin'){
            $private = false;
        }

        ClassLink::create([
            'user_id' => $user->id,
            'course_id' => $request->course,
            'link' => $request->link,
            'time' => $request->time,
            'private' => $private
        ]);

        ToastMagic::success("New class link has been added");
        return redirect()->back();
    }
    public function destroy(Request $request, $id)
    {
        $user = $request->user();
        $class = ClassLink::findOrFail($id);
        if($user->role != 'admin' && $user->id != $class->user_id){
            ToastMagic::error("Fuck You 👆");
            return redirect()->back();
        }
        $class->delete();
        ToastMagic::success("Class link has been deleted");
        return redirect()->back();
    }

    public function joinClass(){
        $data['title'] = "Join Class";
        $user = Auth::user()->load('student');
        $ids = [];
        if($tId = $user->student?->teacher_id){
            $ids[] = $tId;
        }
        if($trId = $user->student?->trainer_id){
            $ids[] = $trId;
        }
        $data['links'] = ClassLink::with('course:id,name', 'user:id,name,role')
        ->where(function($q) use($ids){
            $q->where('private', false)
            ->orWhereIn('user_id', $ids);
        })->latest()->paginate(25);
        return view('student.join_class', $data);
    }
}