<?php

namespace App\Http\Controllers\Payment;

use Illuminate\Support\Facades\Http;

class UddoktaPay {
    
    /**
     * Send payment request
     *
     * @param array $requestData
     * @return void
     */
    
    public function init_payment($requestData) {
        $response = Http::withHeaders( [
            'Content-Type'          => 'application/json',
            'RT-UDDOKTAPAY-API-KEY' => env('UDDOKTAPAY_API_KEY'),
        ] )
            ->asJson()
            ->withBody( json_encode( $requestData ), "JSON" )
            ->post(env('UDDOKTAPAY_BASE_URL')."/checkout-v2" );
            
        if ( $response->successful() ) {
            return $response['payment_url'];
        } else {
            dd( $response );
        }
    }
    
    public function verify_payment($requestData) {
        $response = Http::withHeaders( [
            'Content-Type'          => 'application/json',
            'RT-UDDOKTAPAY-API-KEY' => env('UDDOKTAPAY_API_KEY'),
        ] )
            ->asJson()
            ->withBody( json_encode( $requestData ), "JSON" )
            ->post(env('UDDOKTAPAY_BASE_URL')."/verify-payment" );
            
        if ( $response->successful() ) {
            return $response;
        } else {
            dd( $response);
        }
    }
}