<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'last_withdraw' => 'datetime',
            'pending_fee' => 'datetime',
            'verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function hierarchy()
    {
        return $this->hasOne(UserHierarchy::class);
    }
    public function counselor()
    {
        return $this->hasOneThrough(
            User::class,
            UserHierarchy::class,
            'user_id',          // Foreign key on hierarchy
            'id',               // Foreign key on users
            'id',               // Local key on this model
            'counselor_id'      // Local key on hierarchy
        );
    }
    public function seniorTeamLeader()
    {
        return $this->hasOneThrough(
            User::class,
            UserHierarchy::class,
            'user_id',
            'id',
            'id',
            'senior_team_leader_id'
        );
    }
    public function teamLeader()
    {
        return $this->hasOneThrough(
            User::class,
            UserHierarchy::class,
            'user_id',
            'id',
            'id',
            'team_leader_id'
        );
    }
    public function teamLeaderOfTrainer()
    {
        return $this->hasOneThrough(
            User::class,
            Trainer::class,
            'user_id',
            'id',
            'id',
            'team_leader_id'
        );
    }
    public function teamLeaderOfTeacher()
    {
        return $this->hasOneThrough(
            User::class,
            Teacher::class,
            'user_id',
            'id',
            'id',
            'team_leader_id'
        );
    }
    public function teamLeaderOfStudent()
    {
        return $this->hasOneThrough(
            User::class,
            Student::class,
            'user_id',
            'id',
            'id',
            'team_leader_id'
        );
    }

    public function trainer(){
        return $this->hasOne(Trainer::class);
    }
    public function teacher(){
        return $this->hasOne(Teacher::class);
    }
    
    public function referer()
    {
        return $this->belongsTo(User::class, 'refer_by');
    }
    public function student()
    {
        return $this->hasOne(Student::class);
    }
    public function transactions(){
        return $this->hasMany(Transaction::class);
    }
}