<?php

namespace Database\Seeders;

use App\Models\Setting;
use App\Models\User;
// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        User::create([
            'name' => 'Admin',
            'phone' => '+8801741483338',
            'role' => 'admin',
            'password' => bcrypt('dev@Nahid'),
            'verified_at' => now()
        ]);

        $settings = [
            'site_logo' => '',
            'mobile_logo' => '',
            'email' => '',
            'phone' => '',
            'address' => '',
            'fb_link' => '',
            'yt_link' => '',
            'shop_link' => '',
            'apps_link' => '',
            'notes_board' => '',
            'telegram_link' => '',
            'payment_gateway' => 1,
            'activation_fee' => 10,
            'pending_fee' => 10,
            'student_register_commission_to_referrer' => 1,
            'student_activation_commission_to_referrer' => 1,
            'student_activation_cashback' => 1,
            'student_activation_commission_to_manager' => 1,
            'student_activation_commission_to_counselor' => 1,
            'student_activation_commission_to_stl' => 1,
            'student_activation_commission_to_tl' => 1,
            'student_activation_commission_to_tr' => 1,
            'student_activation_commission_to_teacher' => 1,
            'total_work_limit' => 100,
            'per_day_per_course_work_limit' => 1,
            'active_id_wp_before_text' => "",
            'active_id_wp_after_text' => "",
            'inactive_id_wp_before_text' => "",
            'inactive_id_wp_after_text' => "",
        ];

        foreach($settings as $key => $val){
            Setting::firstOrCreate(
                ['key' => $key],
                [
                'value' => $val,
            ]);
        }
    }
}