<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Login - {{ config('app.name') }}</title>

    <link rel="stylesheet" href="{{ asset('assets/vendors/ti-icons/css/themify-icons.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/css/vertical-layout-light/style.css') }}">

    {!! ToastMagic::styles() !!}

</head>

<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-body p-4">
                        <div class="mb-4">
                            <i class="ti-lock text-warning" style="font-size: 48px;"></i>
                        </div>
                        <h3 class="mb-3">Account Inactive</h3>
                        <p class="text-muted mb-4">Your account is currently inactive. Please complete the payment to
                            activate and continue using our services.</p>

                        <div class="row">
                            <div class="col-md-6">
                                <h5 class="mb-3">Contact Admin</h5>
                                <ul class="list-unstyled mb-4">
                                    <li><strong>Email:</strong> {{ $settings['email'] }}</li>
                                    <li><strong>Phone:</strong> {{ $settings['phone'] }}</li>
                                    <li><strong>WhatsApp:</strong> <a
                                            href="https://wa.me/88{{ $settings['phone'] }}?text={{ wp_msg($user) }}"
                                            target="_blank">Chat Now</a></li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5 class="mb-3">My Info</h5>
                                <ul class="list-unstyled mb-4">
                                    <li><strong>ID:</strong> {{ $user->id }}</li>
                                    <li><strong>Name:</strong> {{ $user->name }}</li>
                                    <li><strong>Phone:</strong> {{ $user->phone }}</li>
                                    <li><strong>Refer By:</strong> {{ $user->referer?->name }}</li>
                                    <li><strong>Joining Date:</strong> {{ $user->created_at->format('d M Y') }}</li>
                                </ul>
                            </div>
                        </div>

                        @if ($user->payment_status == 'unpaid')
                            @if ($settings['payment_gateway'])
                                <form action="{{ route('activation') }}" method="post">
                                    @csrf
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        Activate Now
                                    </button>
                                </form>
                            @endif
                        @else
                            <a href="javascript:void(0)" class="btn btn-success btn-lg">
                                PAID
                            </a>
                        @endif

                        <a class="btn btn-dark mt-3" href="javascript:void(0)" onclick="document.getElementById('logout-form').submit()">
                            <i class="ti-power-off text-primary"></i>
                            Logout
                        </a>
                        <form action="{{ route('logout') }}" method="post" id="logout-form">@csrf</form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>