<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Registration Complete - {{ config('app.name') }}</title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/css/intlTelInput.css">
    <link rel="stylesheet" href="{{ asset('assets/css/vertical-layout-light/style.css') }}">
</head>

<body>
    <div class="container-scroller">
        <div class="container-fluid page-body-wrapper full-page-wrapper">
            <div class="content-wrapper d-flex align-items-center auth px-0">
                <div class="row w-100 mx-0">
                    <div class="col-lg-5 mx-auto">
                        <div class="auth-form-light text-start py-5 px-4 px-sm-5">
                            <div class="brand-logo">
                                <img src="{{ img($settings['site_logo']) }}"
                                    alt="logo">
                            </div>
                            <div class="alert alert-success" role="alert">
                                <h4 class="alert-heading">🎉 Congratulations!</h4>
                                <p>Your account has been successfully created.</p>
                                <hr>
                                <p class="mb-1"><strong>Login ID:</strong> {{ $user->id }}</p>
                                <p class="mb-1"><strong>Password:</strong> {{ $password }}</p>
                                
                                <p class="mb-1"><strong>Name:</strong> {{ $user->name }}</p>
                                <p class="mb-1"><strong>Phone:</strong> {{ $user->phone }}</p>
                                <p class="mb-1"><strong>Email:</strong> {{ $user->email }}</p>
                                <p class="mb-0"><strong>Referral Code:</strong> {{ $user->id }}</p>
                            </div>
                    
                            <div class="text-center mt-4">
                                <a href="{{ route('login') }}" class="btn btn-primary">Go to Login</a>
                            </div>                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- content-wrapper ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>

    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/intlTelInput.min.js"></script>
    <script>
        const input = document.querySelector("#phone");
        intlTelInput(input, {
            loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
            initialCountry: "bd",
            containerClass: "w-100",
            nationalMode: true,
            hiddenInput: (telInputName) => ({
                phone: "phone",
            }),
        })
    </script>
</body>

</html>