@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">Settings</h1>

    <div class="card card-primary card-outline mb-4">

        <form action="{{ route('admin.settings') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="row">
                    @foreach ($settings as $key => $value)
                        <div class="col-md-4 mb-3">
                            <label class="form-label">{{ ucwords(str_replace('_', ' ', $key)) }}</label>

                            @if (in_array($key, ['site_logo', 'mobile_logo']))
                                {{-- File input --}}
                                <input type="file" name="{{ $key }}" class="form-control" />
                                @if ($value)
                                    <small class="d-block mt-1">Current:
                                        <img src="{{ asset('storage/' . $value) }}" alt="{{ $key }}"
                                            height="40">
                                    </small>
                                @endif
                            @elseif ($key == 'payment_gateway')
                                {{-- Select input --}}
                                <select name="{{ $key }}" class="form-select">
                                    <option value="1" {{ $value ? 'selected' : '' }}>Enabled</option>
                                    <option value="0" {{ !$value ? 'selected' : '' }}>Disabled</option>
                                </select>
                            @else
                                {{-- Default text input --}}
                                <input name="{{ $key }}" type="text" class="form-control"
                                    value="{{ $value }}" />
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>

    </div>
@endsection
