@extends('layouts.backend.app')

@section('content')
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h1 class="h3 mb-4">Profile - {{ $user->name }} [#{{ $user->id }}]</h1>
        <a href="{{ request('source') ?? url()->previous() }}" class="btn btn-secondary">Back</a>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <img src="{{ img($user->avatar) }}" class="rounded-circle mb-3" widivh="120" height="120"
                        alt="Avatar">
                    <h5 class="card-title">{{ $user->name }}</h5>
                    <p class="text-muted mb-1">{{ ucfirst($user->role) }}</p>
                    <span class="badge bg-{{ $user->payment_status == 'paid' ? 'success' : 'danger' }}">
                        {{ ucfirst($user->payment_status) }}
                    </span>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-4">Student ID</dt>
                            <dd class="col-sm-8 mb-2">{{ $user->id }}</dd>

                            <dt class="col-sm-4">Phone</dt>
                            <dd class="col-sm-8 mb-2">{{ $user->phone }}</dd>

                            <dt class="col-sm-4">Email</dt>
                            <dd class="col-sm-8 mb-2">{{ $user->email ?? '-' }}</dd>

                            <dt class="col-sm-4">Gender</dt>
                            <dd class="col-sm-8 mb-2">{{ ucfirst($user->gender ?? '-') }}</dd>

                            <dt class="col-sm-4">Address</dt>
                            <dd class="col-sm-8 mb-2">{{ $user->adivress ?? '-' }}</dd>

                            <dt class="col-sm-4">Refer By</dt>
                            <dd class="col-sm-8 mb-2">{{ $user->referer?->name ?? '-' }}</dd>

                            <dt class="col-sm-4">Social Link</dt>
                            <dd class="col-sm-8 mb-2">
                                @if ($user->social_link)
                                    <a href="{{ $user->social_link }}" target="_blank">{{ $user->social_link }}</a>
                                @else
                                    -
                                @endif
                            </dd>

                            <dt class="col-sm-4">Activation Date</dt>
                            <dd class="col-sm-8 mb-2">
                                {{ $user->verified_at ? $user->verified_at->format('d M Y, h:i A') : 'Not Activated' }}
                            </dd>

                            <dt class="col-sm-4">Balance</dt>
                            <dd class="col-sm-8 mb-2">৳{{ number_format($user->balance, 2) }}</dd>

                            <dt class="col-sm-4">Pending Fee Date</dt>
                            <dd class="col-sm-8 mb-2">{{ $user->pending_fee ? $user->pending_fee->format('d M Y') : '-' }}
                            </dd>

                            <dt class="col-sm-4">Last Withdraw</dt>
                            <dd class="col-sm-8 mb-2">
                                {{ $user->last_withdraw ? $user->last_withdraw->format('d M Y') : '-' }}</dd>

                            <dt class="col-sm-4">Status</dt>
                            <dd class="col-sm-8 mb-2">
                                <span class="badge bg-{{ $user->status ? 'success' : 'danger' }}">
                                    {{ $user->status ? 'Active' : 'Blocked' }}
                                </span>
                            </dd>
                        </dl>

                        @if (in_array($role, ['stl', 'tl', 'trainer', 'teacher', 'student']))
                            <hr>
                            <dl class="row">
                                @php
                                    $tl = null;
                                    $stl = null;
                                    $counselor = null;

                                    if ($role == 'stl') {
                                        $counselor = $user->counselor;
                                    } elseif ($role == 'tl') {
                                        $stl = $user->seniorTeamLeader;
                                        $counselor = $stl?->counselor;
                                    } elseif ($role == 'trainer') {
                                        $tl = $user->teamLeaderOfTrainer;
                                    } elseif ($role == 'teacher') {
                                        $tl = $user->teamLeaderOfTeacher;
                                    } elseif ($role == 'student') {
                                        $tl = $user->teamLeaderOfStudent;
                                    }

                                    if (!$counselor && $tl?->seniorTeamLeader) {
                                        $stl = $tl->seniorTeamLeader;
                                        $counselor = $stl?->counselor;
                                    }
                                @endphp


                                <dt class="col-sm-4">Counselor</dt>
                                <dd class="col-sm-8 mb-2">{{ $counselor?->name }} [{{ $counselor?->phone }}]</dd>

                                @if ($stl)
                                    <dt class="col-sm-4">Senior Team Leader</dt>
                                    <dd class="col-sm-8 mb-2">{{ $stl->name }} [{{ $stl->phone }}]</dd>
                                @endif

                                @if ($tl)
                                    <dt class="col-sm-4">Team Leader</dt>
                                    <dd class="col-sm-8 mb-2">{{ $tl->name }} [{{ $tl->phone }}]</dd>
                                @endif

                                @if ($user->student?->trainer)
                                    <dt class="col-sm-4">Trainer</dt>
                                    <dd class="col-sm-8 mb-2">{{ $user->student->trainer?->name }}
                                        [{{ $user->student->trainer?->phone }}]</dd>
                                @endif

                                @if ($user->student?->teacher)
                                    <dt class="col-sm-4">Teacher</dt>
                                    <dd class="col-sm-8 mb-2">{{ $user->student->teacher?->name }}
                                        [{{ $user->student->teacher?->phone }}]</dd>
                                @endif
                            </dl>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
