@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">Withdrawals List</h1>

    <div class="card mb-4">
        <div class="card-header">
            <div class="row">
                <div class="col-md-12 mb-3">
                    @foreach ($statuses as $status)
                        <a href="{{ route('admin.withdrawals', ['status' => $status]) }}"
                            class="btn btn-outline-success btn-sm mr-2 mb-2 {{ request('status') == $status ? 'btn-success text-light' : '' }}">{{ strtoupper($status) }}</a>
                    @endforeach
                </div>
            </div>
        </div>
        <div class="card-body table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Amount</th>
                        <th>Details</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($withdrawals as $withdrawal)
                        <tr>
                            <td>
                                ID: <strong>{{ $withdrawal->user?->id }}</strong> <br>
                                Name: {{ $withdrawal->user?->name }} <br>
                                <i data-feather="phone"></i> {{ $withdrawal->user?->phone }}
                            </td>
                            <td>৳{{ $withdrawal->amount }}</td>
                            @php
                                $details = json_decode($withdrawal->details, true);
                            @endphp
                            <td>
                                <ul class="mb-0 list-style-none">
                                    @foreach ($details as $key => $value)
                                        <li><strong>{{ ucwords(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}</li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>{{ $withdrawal->created_at->format('d M Y') }}</td>
                            <td>
                                @if ($withdrawal->status == 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @elseif($withdrawal->status == 'declined')
                                    <span class="badge bg-danger">Declined</span>
                                @else
                                    <span class="badge bg-warning">Pending</span>
                                @endif
                            </td>
                            <td>
                                @if ($withdrawal->status == 'pending')
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-success" onclick="deleteData({{ $withdrawal->id }}, 'approved')">
                                            <i data-feather="check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteData({{ $withdrawal->id }}, 'declined')">
                                            <i data-feather="x"></i>
                                        </button>
                                    </div>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="p-3">
                {{ $withdrawals->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>

    {{-- individual --}}
    <form action="{{ route('admin.withdrawals') }}" method="post" id="status-form">
        <input type="hidden" name="id" id="user_id">
        <input type="hidden" name="status" id="status">
        @csrf
    </form>
@endsection

@push('js')
    <script>
        function deleteData(id, status) {
            let ask = confirm("Status can't be restored!")
            if (ask) {
                $("#user_id").val(id)
                $("#status").val(status)
                $("#status-form").submit();
            }
        }
    </script>
@endpush
