@extends('layouts.backend.app')

@section('content')
    <h1 class="h3 mb-3">Work Submissions</h1>

    <div class="card mb-4">
        <div class="card-body table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Student</th>
                        <th>Course</th>
                        <th>Link</th>
                        <th>Note</th>
                        <th>Trainer/Teacher</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($works as $i)
                        <tr>
                            <td>{{ $i->created_at->format('d M Y') }}</td>
                            <td>
                                ID: {{ $i->user?->id }} <br>
                                Name: {{ $i->user?->name }}
                            </td>
                            <td>{{ $i->course?->name }}</td>
                            <td>
                                <a target="_blank" href="{{ $i->link }}" class="btn btn-sm btn-primary">Click</a>
                            </td>
                            <td>{{ $i->note }}</td>
                            <td>
                                @if (!$i->trainer_status)
                                @elseif($i->trainer_status == 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @else
                                    <span class="badge bg-danger">Declined</span>
                                @endif
                            </td>
                            <td>
                                @if ($i->status == 'pending')
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-success"
                                        onclick="changeStatus({{ $i->id }}, 'approved')">
                                        <i data-feather="check"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger"
                                        onclick="changeStatus({{ $i->id }}, 'declined')">
                                        <i data-feather="x"></i>
                                    </button>
                                </div>
                                @elseif($i->status == 'approved')
                                    <span class="badge bg-success">Approved</span>
                                @else
                                    <span class="badge bg-danger">Declined</span>
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-sm btn-danger" onclick="deleteData({{ $i->id }})">
                                    <i data-feather="trash-2"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="p-3">
                {{ $works->links('pagination::bootstrap-5') }}
            </div>
        </div>
    </div>

    {{-- individual --}}
    <form action="{{ route('works') }}" method="post" id="status-form">
        <input type="hidden" name="id" id="user_id">
        <input type="hidden" name="status" id="status">
        @csrf
    </form>
    <form action="#" method="post" id="delete-form">
        @csrf
        @method('DELETE')
    </form>
@endsection

@push('js')
    <script>
        function changeStatus(id, status) {
            let ask = confirm("Status can't be restored!")
            if (ask) {
                $("#user_id").val(id)
                $("#status").val(status)
                $("#status-form").submit();
            }
        }
        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored!")
            if (ask) {
                $("#delete-form").attr('action', `{{ route('users.index') }}/${id}`);
                $("#delete-form").submit();
            }
        }
    </script>
@endpush