@extends('layouts.app')

@push('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/css/intlTelInput.css">
    <link rel="stylesheet" href="{{ asset('assets/vendors/select2/select2.min.css') }}">
@endpush

@section('content')
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h3 class="mb-4">Create new student</h3>
        <a href="{{ route('users.index') }}" class="btn btn-secondary">Back</a>
    </div>

    <div class="card">
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </div>
            @endif
            <form action="{{ route('users.store') }}" method="POST">
                @csrf
                <input type="hidden" name="role" value="{{ $role }}">
                <input type="hidden" name="phone">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name*</label>
                        <input type="text" name="name" class="form-control form-control-sm" required
                            value="{{ old('name') }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Phone*</label>
                        <input type="text" id="phone" class="form-control form-control-sm" required
                            value="{{ old('phone') }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control form-control-sm"
                            value="{{ old('email') }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Gender</label>
                        <select name="gender" class="form-select">
                            <option value="">Select</option>
                            <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Male</option>
                            <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Female</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Address</label>
                        <input type="text" name="address" class="form-control form-control-sm"
                            value="{{ old('address') }}">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password*</label>
                        <input type="password" name="password" class="form-control form-control-sm" required>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Payment Status</label>
                        <select name="payment_status" class="form-select">
                            <option value="unpaid" {{ old('payment_status') == 'unpaid' ? 'selected' : '' }}>Unpaid
                            </option>
                            <option value="paid" {{ old('payment_status') == 'paid' ? 'selected' : '' }}>Paid</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="1" {{ old('status', '1') == '1' ? 'selected' : '' }}>Active</option>
                            <option value="0" {{ old('status') == '0' ? 'selected' : '' }}>Blocked</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Counselor*</label>
                        <select name="counselor" id="counselor" class="select2 w-100" required>
                            <option value="" selected>Select Option</option>
                            @foreach ($counselors as $cn)
                                <option value="{{ $cn->id }}">{{ $cn->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Senior Team Leader*</label>
                        <select name="stl" class="select2 w-100" id="stl" required>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Team Leader*</label>
                        <select name="tl" class="select2 w-100" id="tl" required>
                        </select>
                    </div>
                    <div class="col-12 mt-4">
                        <button class="btn btn-primary">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{ asset('assets/vendors/select2/select2.min.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/intlTelInput.min.js"></script>
    <script>
        $('.select2').select2()
        intlTelInput(document.getElementById("phone"), {
            loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
            initialCountry: "bd",
            containerClass: "w-100",
            nationalMode: true,
            hiddenInput: (telInputName) => ({
                phone: "phone",
            }),
        })
        $("#counselor").on("change", function(e) {
            if ($("#stl")[0]) {
                $.ajax({
                    type: "GET",
                    url: `/users/${e.target.value}/stls`,
                    success: function(response) {
                        let html = `<option value="">Select option</option>`
                        $.each(response, function(indexInArray, valueOfElement) {
                            if (valueOfElement.user) {
                                html +=
                                    `<option value="${valueOfElement.user.id}">${valueOfElement.user.name}</option>`
                            }
                        });
                        $("#stl").html(html)
                    }
                });
            }
        });
        $("#stl").on("change", function(e) {
            if ($("#tl")[0]) {
                $.ajax({
                    type: "GET",
                    url: `/users/${e.target.value}/tls`,
                    success: function(response) {
                        let html = `<option value="">Select option</option>`
                        $.each(response, function(indexInArray, valueOfElement) {
                            if (valueOfElement.user) {
                                html +=
                                    `<option value="${valueOfElement.user.id}">${valueOfElement.user.name}</option>`
                            }
                        });
                        $("#tl").html(html)
                    }
                });
            }
        });
    </script>
@endpush
