@extends('layouts.app')

@section('content')
    <h3 class="mb-4">All Team Leads</h3>
    <div class="card">
        <div class="card-body">
            <form action="" method="get">
                <div class="row mb-3">
                    <div class="row">
                        <div class="col-md-3">
                            <label class="form-label" for="type">Type</label>
                            <select name="type" required class="form-select">
                                <option value="1" {{ request('type') == 1 ? 'selected' : '' }}>Converted</option>
                                <option value="0" {{ request('type') == 0 ? 'selected' : '' }}>Leads</option>
                            </select>

                        </div>
                        <div class="col-md-3">
                            <label class="form-label" for="from">From</label>
                            <input type="date" name="from" class="form-control form-control-sm"
                                value="{{ request('from') }}" required />
                        </div>
                        <div class="col-md-3">
                            <label class="form-label" for="to">To</label>
                            <input type="date" name="to" class="form-control form-control-sm"
                                value="{{ request('to') }}" required />
                        </div>
                        <div class="col-md-3">
                            <button type="submit" class="btn btn-dark mt-4">Search Leads</button>
                        </div>
                    </div>
                </div>
            </form>
            <div class="mb-3 text-danger">
                Total Results: {{ $leads->total() }} <br>
            </div>
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Student ID</th>
                            <th>Name</th>
                            <th>Refer By</th>
                            <th>Joining Date</th>
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($leads as $lead)
                            <tr>
                                <td><strong>{{ $lead->id }}</strong></td>
                                <td>{{ $lead->name }}</td>
                                <td>{{ $lead->referer?->name }}</td>
                                <td>{{ $lead->created_at->format('d M Y') }}</td>
                                <td>
                                    <a href="https://wa.me/{{ $lead->phone }}?text={{ wp_msg($lead) }}" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $leads->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection
