@extends('layouts.app')

@section('content')
<h3 class="mb-4">All Trainers</h3>

    <div class="card">
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            @if ($user->role != 'tl')
                                <th>Team Leader</th>
                            @endif
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($trainers as $trainer)
                            <tr>
                                <td>{{ $trainer->user?->id }}</td>
                                <td><img src="{{ img($trainer->user?->avatar) }}" width="60" class="rounded-circle"></td>
                                <td>{{ $trainer->user?->name }}</td>
                                @if ($user->role != 'tl')
                                    <td>{{ $trainer->team_leader?->name }}</td>
                                @endif
                                <td>
                                    <a href="https://wa.me/{{ $trainer->user?->phone }}?text={{ wp_msg($trainer->user) }}" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $trainers->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection
