@extends('layouts.app')

@section('content')
<h3 class="mb-4">All Class Links</h3>

    <div class="card">
        <div class="card-header">
            @if ($course)
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">Add New</button>
            @endif
        </div>
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($links as $i)
                            <tr>
                                <td>
                                    {{ $i->course?->name }}
                                </td>
                                <td>
                                    <a target="_blank" href="{{ $i->link }}" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td>
                                    {{ $i->time->format('d M Y, h:i a') }}
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-danger" onclick="deleteData({{ $i->id }})">
                                        <i class="ti-trash text-white"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $links->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>

    @if ($course)
        <!-- Modal -->
        <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <form action="{{ route('classLinks') }}" method="post">
                    @csrf
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="addModalLabel">Add new class link</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="" class="form-label">Course</label>
                                <select name="course" class="form-select" required>
                                    <option value="{{ $course->id }}" selected>{{ $course->name }}</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="" class="form-label">Link</label>
                                <input type="text" name="link" class="form-control form-control-sm" required>
                            </div>
                            <div class="mb-3">
                                <label for="" class="form-label">Time</label>
                                <input type="datetime-local" name="time" class="form-control form-control-sm" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    @endif

    <form action="" method="post" id="delete-form">@csrf @method('DELETE')</form>
@endsection

@push('js')
    <script>
        const deleteForm = document.getElementById('delete-form');

        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored");
            if (ask) {
                deleteForm.action = window.location.origin + window.location.pathname + '/' + id;
                deleteForm.submit();
            }
        }
    </script>
@endpush