@extends('layouts.app')

@section('content')
<h3 class="mb-4">Withdrawals</h3>

    <div class="card">
        <div class="card-body">
            <h5 class="mb-3">Current Balance: <strong>৳{{ $user->balance }}</strong></h5>
            <h5 class="text-info mb-3">Withdraw Time: 1 time in a week</h5>

            <div class="mb-4">
                <form action="{{ route('withdrawal') }}" method="POST">
                    @csrf
                    @if (!$user->pending_fee)
                        <label class="form-label mb-3 d-block text-warning" for="referralURL">Note: Your pending fee is
                            ৳{{ $settings['pending_fee'] }}</label>
                        <button type="submit" class="btn btn-primary">Pay Pending Fee</button>
                    @else
                        @if (!$user->last_withdraw || \Carbon\Carbon::parse($user->last_withdraw)->diffInDays(now()) >= 7)
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Account Number</label>
                                    <input type="text" name="account_number" class="form-control form-control-sm"
                                        placeholder="018********" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Payment Method</label>
                                    <select name="method" class="form-select" required>
                                        <option value="">Select Method</option>
                                        <option value="Bkash">Bkash</option>
                                        <option value="Nagad">Nagad</option>
                                        <option value="Rocket">Rocket</option>
                                        <option value="Upay">Upay</option>
                                        <option value="Google Pay">Google Pay</option>
                                        <option value="Paytm">Paytm</option>
                                        <option value="PhonePe">PhonePe</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Account Type</label>
                                    <select name="type" class="form-select" required>
                                        <option value="personal">Personal</option>
                                        <option value="agent">Agent</option>
                                        <option value="merchant">Merchant</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Amount</label>
                                    <input type="number" name="amount" min="1" max="{{ $user->balance }}"
                                        class="form-control form-control-sm" placeholder="Type amount" required>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">Make Withdraw</button>
                                </div>
                            </div>
                        @endif
                    @endif
                </form>
            </div>

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Request Date</th>
                            <th>Amount</th>
                            <th>Details</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($withdrawals as $key => $i)
                        @php
                            $details = json_decode($i->details, true);
                        @endphp

                            <tr>
                                <td>{{ $withdrawals->firstItem() + $key }}</td>
                                <td>{{ $i->created_at->format('d M Y') }}</td>
                                <td>{{ $i->amount }}</td>
                                <td>
                                    <ul class="mb-0 list-style-none">
                                        @foreach ($details as $key => $value)
                                            <li><strong>{{ ucwords(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}</li>
                                        @endforeach
                                    </ul>                                    
                                </td>
                                <td>
                                    @if ($i->status == 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($i->status == 'approved')
                                        <span class="badge bg-success">Approved</span>
                                    @else
                                        <span class="badge bg-danger">Declined</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $withdrawals->links('pagination::bootstrap-5') }}
                </div>
            </div>
        </div>
    </div>
@endsection
