<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Backend\CourseController;
use App\Http\Controllers\Backend\DashboardController;
use App\Http\Controllers\Backend\UserDataController;
use App\Http\Controllers\Backend\UserController;
use App\Http\Controllers\Backend\WithdrawalController;
use App\Http\Controllers\ClassLinkController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\HomeWorkController;
use App\Http\Controllers\RoleDataController;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

Route::get('/link', function(){
    Artisan::call('storage:link');
});
Route::get('/', [HomeController::class, 'home']);

Auth::routes();
Route::get('subadmin', [LoginController::class, 'subadmin'])->name('subadmin.login');

Route::get('activation', [HomeController::class, 'activationView']);
Route::post('activation', [HomeController::class, 'activationPay'])->name('activation');
Route::any('payment/success', [HomeController::class, 'successPayment'])->name('payment.success');
Route::any('payment/cancel', [HomeController::class, 'cancelPayment'])->name('payment.cancel');

Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['auth', 'admin']], function(){
    Route::get('/dashboard', [DashboardController::class, 'dashboard'])->name('dashboard');
    
    Route::resource('courses', CourseController::class);

    Route::get('withdrawals', [WithdrawalController::class, 'index'])->name('withdrawals');
    Route::post('withdrawals', [WithdrawalController::class, 'update'])->name('withdrawals');

    Route::get('settings', [DashboardController::class, 'settings'])->name('settings');
    Route::post('settings', [DashboardController::class, 'updateSettings'])->name('settings');
    Route::delete('works/{id}', [HomeWorkController::class, 'destroy'])->name('works.destroy');
});

Route::group(['middleware' => ['auth', 'common']], function(){
    Route::get('users/search', [UserController::class, 'search'])->name('users.search');
    Route::resource('users', UserController::class);
    Route::get('users/{id}/stls', [UserDataController::class, 'fetchStls']);
    Route::get('users/{id}/tls', [UserDataController::class, 'fetchTls']);
    Route::post('users/update-balance', [UserDataController::class, 'updateBalance'])->name('updateBalance');
});

Route::group(['middleware' => ['auth', 'active']], function(){
    Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');
    Route::get('/profile', [HomeController::class, 'showProfile'])->name('profile');
    Route::post('/profile', [HomeController::class, 'updateProfile'])->name('profile');

    Route::get('/referral', [HomeController::class, 'referralPage'])->name('referral');
    Route::get('/passbook', [HomeController::class, 'passbook'])->name('passbook');

    Route::get('/withdrawal', [HomeController::class, 'withdrawal'])->name('withdrawal');
    Route::post('/withdrawal', [HomeController::class, 'storeWithdrawal'])->name('withdrawal');
    
    Route::get('/senior-team-leaders', [RoleDataController::class, 'seniorTeamLeaders'])->name('seniorTeamLeaders');
    Route::get('/team-leaders', [RoleDataController::class, 'teamLeaders'])->name('teamLeaders');
    Route::get('/trainers', [RoleDataController::class, 'trainers'])->name('trainers');
    Route::get('/teachers', [RoleDataController::class, 'teachers'])->name('teachers');
    Route::get('/students', [RoleDataController::class, 'students'])->name('students');
    Route::get('/students/{id}/edit', [RoleDataController::class, 'editStudent'])->name('students.edit');
    Route::put('/students/{id}', [RoleDataController::class, 'updateStudent'])->name('students.update');
    Route::get('/team-leads', [RoleDataController::class, 'teamLeads'])->name('team-leads');

    Route::get('/class-links', [ClassLinkController::class, 'index'])->name('classLinks');
    Route::post('/class-links', [ClassLinkController::class, 'store'])->name('classLinks');
    Route::delete('/class-links/{id}', [ClassLinkController::class, 'destroy'])->name('classLinks.destroy');
    Route::get('/join-class', [ClassLinkController::class, 'joinClass'])->name('joinClass');

    Route::get('work-submit', [HomeWorkController::class, 'studentWorks'])->name('studentWorks');
    Route::post('work-submit', [HomeWorkController::class, 'storeStudentWorks'])->name('studentWorks');
    Route::get('works', [HomeWorkController::class, 'index'])->name('works');
    Route::post('works', [HomeWorkController::class, 'changeStatus'])->name('works');
});