<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Login - <?php echo e(config('app.name')); ?></title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/css/intlTelInput.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vertical-layout-light/style.css')); ?>">
</head>

<body>
    <div class="container-scroller">
        <div class="container-fluid page-body-wrapper full-page-wrapper">
            <div class="content-wrapper d-flex align-items-center auth px-0">
                <div class="row w-100 mx-0">
                    <div class="col-lg-5 mx-auto">
                        <div class="auth-form-light text-start py-5 px-4 px-sm-5">
                            <div class="brand-logo">
                                <img src="<?php echo e(img($settings['site_logo'])); ?>"
                                    alt="logo">
                            </div>
                            <h4>Sign in to continue.</h4>
                            <form class="pt-3" method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="source" value="subadmin">
                                <div class="form-group mb-3">
                                    <select name="role" class="form-select" required>
                                        <option value="counselor">Counselor</option>
                                        <option value="stl">Senior Team Leader</option>
                                        <option value="tl">Team Leader</option>
                                        <option value="trainer">Trainer</option>
                                        <option value="teacher">Teacher</option>
                                        <option value="manager">Account Manager</option>
                                         <option value="Selling">Selling Team</option>
                                        <option value="Qualification">Qualification Team</option>
                                        <option value="Marketing">Marketing Team </option>
                                        <option value="teacher">Video Editing Teacher</option>
                                        <option value="teacher">Photo Editing Teacher</option>
                                        <option value="Web">Web Developer</option>
                                        <option value="smanager">Senior Manager</option>
                                        <option value="Controlloer">Controlloer</option>
                                    </select>
                                </div>

                                <div class="form-group mb-4">
                                    <label class="form-label d-block">Login with</label>
                                    <div class="btn-group" role="group" aria-label="Login Method">
                                        <input type="radio" class="btn-check" name="login_type" id="loginWithId"
                                            value="id" autocomplete="off" checked>
                                        <label class="btn btn-outline-primary" for="loginWithId">Student ID</label>

                                        <input type="radio" class="btn-check" name="login_type" id="loginWithPhone"
                                            value="phone" autocomplete="off">
                                        <label class="btn btn-outline-primary" for="loginWithPhone">Phone</label>
                                    </div>
                                </div>

                                <div class="form-group" id="login-id-field">
                                    <input type="text" name="id" id="login_id"
                                        class="form-control form-control-lg" placeholder="Student ID*" required>
                                </div>

                                <div class="form-group d-none" id="login-phone-field">
                                    <input type="text" id="login_phone"
                                        class="form-control form-control-lg" placeholder="Phone Number*">
                                </div>

                                <?php $__errorArgs = ['id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="text-danger"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                <div class="form-group">
                                    <input type="password" name="password" class="form-control form-control-lg"
                                        placeholder="Password*" required>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <p class="text-danger"><?php echo e($message); ?></p>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mt-3 d-grid gap-2">
                                    <button type="submit"
                                        class="btn btn-block btn-primary btn-lg fw-medium auth-form-btn">SIGN
                                        IN</button>
                                </div>

                                <div class="text-center mt-4 fw-light">
                                    New User? <a href="<?php echo e(route('register')); ?>" class="text-primary">Create an
                                        Account</a>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
            <!-- content-wrapper ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>

    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/intlTelInput.min.js"></script>
    <script>
        const input = document.getElementById("login_phone");
        intlTelInput(input, {
            loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
            initialCountry: "bd",
            containerClass: "w-100",
            nationalMode: true,
            hiddenInput: (telInputName) => ({
                phone: "phone",
            }),
        })
    </script>
    <script>
        document.getElementById('loginWithId').addEventListener('change', function() {
            document.getElementById('login-id-field').classList.remove('d-none');
            document.getElementById('login-phone-field').classList.add('d-none');
            document.getElementById('login_id').setAttribute('required', 'required');
            document.getElementById('login_phone').removeAttribute('required');
        });

        document.getElementById('loginWithPhone').addEventListener('change', function() {
            document.getElementById('login-phone-field').classList.remove('d-none');
            document.getElementById('login-id-field').classList.add('d-none');
            document.getElementById('login_phone').setAttribute('required', 'required');
            document.getElementById('login_id').removeAttribute('required');
        });
    </script>
</body>

</html>
<?php /**PATH /home/oursopno/smm.oursopnozonebd.top/resources/views/auth/subadmin.blade.php ENDPATH**/ ?>