<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="robots" content="index, follow">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(env('APP_NAME')); ?></title>
    <?php
        $authUser = @auth()->user();
    ?>

    <link href="https://cdn.jsdelivr.net/npm/daisyui@4.6.0/dist/full.min.css" rel="stylesheet" type="text/css">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" id="google-fonts-1-css"
        href="https://fonts.googleapis.com/css?family=Roboto%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CRoboto+Slab%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CInter%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic%7CPoppins%3A100%2C100italic%2C200%2C200italic%2C300%2C300italic%2C400%2C400italic%2C500%2C500italic%2C600%2C600italic%2C700%2C700italic%2C800%2C800italic%2C900%2C900italic&amp;display=swap&amp;ver=6.4.5"
        media="all">
    <style>
        body {
            font-family: Roboto;
        }

        .hero-bg {
            background-image: url(/assets/home/hero-bg-image.webp);
            background-position: center center;
            background-repeat: no-repeat;
            background-size: cover;
        }

        .custom-footer {
            color: white;
            padding: 40px 20px;
            margin-top: auto;
            text-align: center;
        }

        .custom-footer a {
            color: inherit;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .custom-footer a:hover {
            color: #0d6efd;
        }

        .custom-footer-grid {
            display: grid;
            gap: 24px;
        }

        .custom-footer-logo img {
            width: 80px;
            margin-bottom: 16px;
        }

        .custom-footer-social {
            display: flex;
            justify-content: center;
            gap: 12px;
            margin-top: 16px;
        }

        .custom-footer-social a {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
            border: 1px solid white;
            border-radius: 5px;
            transition: all 0.3s ease;
        }

        .custom-footer-social a:hover {
            border-color: #0d6efd;
            color: #0d6efd;
            transform: scale(1.1);
        }

        .custom-footer-apps {
            display: flex;
            gap: 12px;
            margin-top: 24px;
            justify-content: center;
        }

        .custom-footer-apps img {
            width: 140px;
        }

        .custom-footer-section h3 {
            font-size: 18px;
            font-weight: 500;
            margin-bottom: 14px;
            color: #fff;
            margin-right: 179px;
        }

        .custom-footer-section ul {
            list-style: none;
        }

        .custom-footer-section ul li {
            margin-bottom: 8px;
        }

        .custom-footer-section ul li a {
            display: flex;
            align-items: center;
            gap: 8px;
            color: #fff;
        }

        .custom-footer-section ul li a ion-icon {
            font-size: 16px;
        }

        @media (max-width: 767px) {
            .custom-footer-grid {
                grid-template-columns: 1fr;
                text-align: center;
            }

            .custom-footer-section.policy {
                display: none;
            }

            .mobile-nav {
                display: block;
            }
        }

        @media (min-width: 768px) {
            .custom-footer-grid {
                grid-template-columns: repeat(4, 1fr);
            }
        }

        .footer-copyright {
            color: white;
            padding: 10px 0;
            margin-top: 2px;
            font-size: 14px;
        }

        .footer-copyright {
            background-color: #351f56;
            color: white;
            padding: 10px 0;
            margin-top: 2px;
            font-size: 14px;
        }

        .custom-footer {
            background-color: #28274d;
            color: white;
            padding: 40px 20px;
            margin-top: auto;
            text-align: center;
        }
    </style>
    <!-- tailwind custom css -->
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        clifford: '#da373d',
                        "btn-color": '#FF4667',
                        "text-color": '#392C7D',
                        "header-footer-bg": '#EEEAFF',
                        "section-bg": '#FBDFDB',
                        "copyright-bg": '#FF4667',
                    }
                }
            }
        }
    </script>

    <style>
        *,
        ::before,
        ::after {
            --tw-border-spacing-x: 0;
            --tw-border-spacing-y: 0;
            --tw-translate-x: 0;
            --tw-translate-y: 0;
            --tw-rotate: 0;
            --tw-skew-x: 0;
            --tw-skew-y: 0;
            --tw-scale-x: 1;
            --tw-scale-y: 1;
            --tw-pan-x: ;
            --tw-pan-y: ;
            --tw-pinch-zoom: ;
            --tw-scroll-snap-strictness: proximity;
            --tw-gradient-from-position: ;
            --tw-gradient-via-position: ;
            --tw-gradient-to-position: ;
            --tw-ordinal: ;
            --tw-slashed-zero: ;
            --tw-numeric-figure: ;
            --tw-numeric-spacing: ;
            --tw-numeric-fraction: ;
            --tw-ring-inset: ;
            --tw-ring-offset-width: 0px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: rgb(59 130 246 / 0.5);
            --tw-ring-offset-shadow: 0 0 #0000;
            --tw-ring-shadow: 0 0 #0000;
            --tw-shadow: 0 0 #0000;
            --tw-shadow-colored: 0 0 #0000;
            --tw-blur: ;
            --tw-brightness: ;
            --tw-contrast: ;
            --tw-grayscale: ;
            --tw-hue-rotate: ;
            --tw-invert: ;
            --tw-saturate: ;
            --tw-sepia: ;
            --tw-drop-shadow: ;
            --tw-backdrop-blur: ;
            --tw-backdrop-brightness: ;
            --tw-backdrop-contrast: ;
            --tw-backdrop-grayscale: ;
            --tw-backdrop-hue-rotate: ;
            --tw-backdrop-invert: ;
            --tw-backdrop-opacity: ;
            --tw-backdrop-saturate: ;
            --tw-backdrop-sepia: ;
            --tw-contain-size: ;
            --tw-contain-layout: ;
            --tw-contain-paint: ;
            --tw-contain-style:
        }

        ::backdrop {
            --tw-border-spacing-x: 0;
            --tw-border-spacing-y: 0;
            --tw-translate-x: 0;
            --tw-translate-y: 0;
            --tw-rotate: 0;
            --tw-skew-x: 0;
            --tw-skew-y: 0;
            --tw-scale-x: 1;
            --tw-scale-y: 1;
            --tw-pan-x: ;
            --tw-pan-y: ;
            --tw-pinch-zoom: ;
            --tw-scroll-snap-strictness: proximity;
            --tw-gradient-from-position: ;
            --tw-gradient-via-position: ;
            --tw-gradient-to-position: ;
            --tw-ordinal: ;
            --tw-slashed-zero: ;
            --tw-numeric-figure: ;
            --tw-numeric-spacing: ;
            --tw-numeric-fraction: ;
            --tw-ring-inset: ;
            --tw-ring-offset-width: 0px;
            --tw-ring-offset-color: #fff;
            --tw-ring-color: rgb(59 130 246 / 0.5);
            --tw-ring-offset-shadow: 0 0 #0000;
            --tw-ring-shadow: 0 0 #0000;
            --tw-shadow: 0 0 #0000;
            --tw-shadow-colored: 0 0 #0000;
            --tw-blur: ;
            --tw-brightness: ;
            --tw-contrast: ;
            --tw-grayscale: ;
            --tw-hue-rotate: ;
            --tw-invert: ;
            --tw-saturate: ;
            --tw-sepia: ;
            --tw-drop-shadow: ;
            --tw-backdrop-blur: ;
            --tw-backdrop-brightness: ;
            --tw-backdrop-contrast: ;
            --tw-backdrop-grayscale: ;
            --tw-backdrop-hue-rotate: ;
            --tw-backdrop-invert: ;
            --tw-backdrop-opacity: ;
            --tw-backdrop-saturate: ;
            --tw-backdrop-sepia: ;
            --tw-contain-size: ;
            --tw-contain-layout: ;
            --tw-contain-paint: ;
            --tw-contain-style:
        }

        /* ! tailwindcss v3.4.16 | MIT License | https://tailwindcss.com */
        *,
        ::after,
        ::before {
            box-sizing: border-box;
            border-width: 0;
            border-style: solid;
            border-color: #e5e7eb
        }

        ::after,
        ::before {
            --tw-content: ''
        }

        :host,
        html {
            line-height: 1.5;
            -webkit-text-size-adjust: 100%;
            -moz-tab-size: 4;
            tab-size: 4;
            font-family: ui-sans-serif, system-ui, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
            font-feature-settings: normal;
            font-variation-settings: normal;
            -webkit-tap-highlight-color: transparent
        }

        body {
            margin: 0;
            line-height: inherit
        }

        hr {
            height: 0;
            color: inherit;
            border-top-width: 1px
        }

        abbr:where([title]) {
            -webkit-text-decoration: underline dotted;
            text-decoration: underline dotted
        }

        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-size: inherit;
            font-weight: inherit
        }

        a {
            color: inherit;
            text-decoration: inherit
        }

        b,
        strong {
            font-weight: bolder
        }

        code,
        kbd,
        pre,
        samp {
            font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            font-feature-settings: normal;
            font-variation-settings: normal;
            font-size: 1em
        }

        small {
            font-size: 80%
        }

        sub,
        sup {
            font-size: 75%;
            line-height: 0;
            position: relative;
            vertical-align: baseline
        }

        sub {
            bottom: -.25em
        }

        sup {
            top: -.5em
        }

        table {
            text-indent: 0;
            border-color: inherit;
            border-collapse: collapse
        }

        button,
        input,
        optgroup,
        select,
        textarea {
            font-family: inherit;
            font-feature-settings: inherit;
            font-variation-settings: inherit;
            font-size: 100%;
            font-weight: inherit;
            line-height: inherit;
            letter-spacing: inherit;
            color: inherit;
            margin: 0;
            padding: 0
        }

        button,
        select {
            text-transform: none
        }

        button,
        input:where([type=button]),
        input:where([type=reset]),
        input:where([type=submit]) {
            -webkit-appearance: button;
            background-color: transparent;
            background-image: none
        }

        :-moz-focusring {
            outline: auto
        }

        :-moz-ui-invalid {
            box-shadow: none
        }

        progress {
            vertical-align: baseline
        }

        ::-webkit-inner-spin-button,
        ::-webkit-outer-spin-button {
            height: auto
        }

        [type=search] {
            -webkit-appearance: textfield;
            outline-offset: -2px
        }

        ::-webkit-search-decoration {
            -webkit-appearance: none
        }

        ::-webkit-file-upload-button {
            -webkit-appearance: button;
            font: inherit
        }

        summary {
            display: list-item
        }

        blockquote,
        dd,
        dl,
        figure,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6,
        hr,
        p,
        pre {
            margin: 0
        }

        fieldset {
            margin: 0;
            padding: 0
        }

        legend {
            padding: 0
        }

        menu,
        ol,
        ul {
            list-style: none;
            margin: 0;
            padding: 0
        }

        dialog {
            padding: 0
        }

        textarea {
            resize: vertical
        }

        input::placeholder,
        textarea::placeholder {
            opacity: 1;
            color: #9ca3af
        }

        [role=button],
        button {
            cursor: pointer
        }

        :disabled {
            cursor: default
        }

        audio,
        canvas,
        embed,
        iframe,
        img,
        object,
        svg,
        video {
            display: block;
            vertical-align: middle
        }

        img,
        video {
            max-width: 100%;
            height: auto
        }

        [hidden]:where(:not([hidden=until-found])) {
            display: none
        }

        .z-\[1\] {
            z-index: 1
        }

        .col-span-2 {
            grid-column: span 2 / span 2
        }

        .mx-auto {
            margin-left: auto;
            margin-right: auto
        }

        .mb-10 {
            margin-bottom: 2.5rem
        }

        .mb-5 {
            margin-bottom: 1.25rem
        }

        .mr-3 {
            margin-right: 0.75rem
        }

        .mt-16 {
            margin-top: 4rem
        }

        .mt-3 {
            margin-top: 0.75rem
        }

        .mt-5 {
            margin-top: 1.25rem
        }

        .flex {
            display: flex
        }

        .grid {
            display: grid
        }

        .hidden {
            display: none
        }

        .h-5 {
            height: 1.25rem
        }

        .h-\[700px\] {
            height: 700px
        }

        .w-16 {
            width: 4rem
        }

        .w-5 {
            width: 1.25rem
        }

        .w-5\/6 {
            width: 83.333333%
        }

        .w-52 {
            width: 13rem
        }

        .w-full {
            width: 100%
        }

        .max-w-7xl {
            max-width: 80rem
        }

        .grid-cols-1 {
            grid-template-columns: repeat(1, minmax(0, 1fr))
        }

        .grid-cols-2 {
            grid-template-columns: repeat(2, minmax(0, 1fr))
        }

        .flex-col {
            flex-direction: column
        }

        .items-center {
            align-items: center
        }

        .justify-center {
            justify-content: center
        }

        .justify-between {
            justify-content: space-between
        }

        .justify-evenly {
            justify-content: space-evenly
        }

        .gap-1 {
            gap: 0.25rem
        }

        .gap-4 {
            gap: 1rem
        }

        .rounded {
            border-radius: 0.25rem
        }

        .rounded-full {
            border-radius: 9999px
        }

        .rounded-xl {
            border-radius: 0.75rem
        }

        .border {
            border-width: 1px
        }

        .border-text-color {
            --tw-border-opacity: 1;
            border-color: rgb(57 44 125 / var(--tw-border-opacity, 1))
        }

        .bg-\[\#FFFFFF\] {
            --tw-bg-opacity: 1;
            background-color: rgb(255 255 255 / var(--tw-bg-opacity, 1))
        }

        .bg-btn-color {
            --tw-bg-opacity: 1;
            background-color: rgb(255 70 103 / var(--tw-bg-opacity, 1))
        }

        .bg-header-footer-bg {
            --tw-bg-opacity: 1;
            background-color: rgb(238 234 255 / var(--tw-bg-opacity, 1))
        }

        .bg-section-bg {
            --tw-bg-opacity: 1;
            background-color: rgb(251 223 219 / var(--tw-bg-opacity, 1))
        }

        .bg-text-color {
            --tw-bg-opacity: 1;
            background-color: rgb(57 44 125 / var(--tw-bg-opacity, 1))
        }

        .bg-white {
            --tw-bg-opacity: 1;
            background-color: rgb(255 255 255 / var(--tw-bg-opacity, 1))
        }

        .bg-copyright-bg {
            --tw-bg-opacity: 1;
            background-color: rgb(255 70 103 / var(--tw-bg-opacity, 1))
        }

        .p-2 {
            padding: 0.5rem
        }

        .p-3 {
            padding: 0.75rem
        }

        .p-4 {
            padding: 1rem
        }

        .p-5 {
            padding: 1.25rem
        }

        .p-10 {
            padding: 2.5rem
        }

        .px-1 {
            padding-left: 0.25rem;
            padding-right: 0.25rem
        }

        .px-4 {
            padding-left: 1rem;
            padding-right: 1rem
        }

        .py-16 {
            padding-top: 4rem;
            padding-bottom: 4rem
        }

        .py-4 {
            padding-top: 1rem;
            padding-bottom: 1rem
        }

        .pb-16 {
            padding-bottom: 4rem
        }

        .pb-2 {
            padding-bottom: 0.5rem
        }

        .pb-6 {
            padding-bottom: 1.5rem
        }

        .pt-16 {
            padding-top: 4rem
        }

        .pt-4 {
            padding-top: 1rem
        }

        .text-center {
            text-align: center
        }

        .text-3xl {
            font-size: 1.875rem;
            line-height: 2.25rem
        }

        .text-4xl {
            font-size: 2.25rem;
            line-height: 2.5rem
        }

        .text-\[18px\] {
            font-size: 18px
        }

        .text-xl {
            font-size: 1.25rem;
            line-height: 1.75rem
        }

        .text-2xl {
            font-size: 1.5rem;
            line-height: 2rem
        }

        .text-\[16px\] {
            font-size: 16px
        }

        .font-bold {
            font-weight: 700
        }

        .font-extrabold {
            font-weight: 800
        }

        .font-semibold {
            font-weight: 600
        }

        .text-black {
            --tw-text-opacity: 1;
            color: rgb(0 0 0 / var(--tw-text-opacity, 1))
        }

        .text-btn-color {
            --tw-text-opacity: 1;
            color: rgb(255 70 103 / var(--tw-text-opacity, 1))
        }

        .text-text-color {
            --tw-text-opacity: 1;
            color: rgb(57 44 125 / var(--tw-text-opacity, 1))
        }

        .text-white {
            --tw-text-opacity: 1;
            color: rgb(255 255 255 / var(--tw-text-opacity, 1))
        }

        .shadow {
            --tw-shadow: 0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1);
            --tw-shadow-colored: 0 1px 3px 0 var(--tw-shadow-color), 0 1px 2px -1px var(--tw-shadow-color);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)
        }

        .shadow-xl {
            --tw-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
            --tw-shadow-colored: 0 20px 25px -5px var(--tw-shadow-color), 0 8px 10px -6px var(--tw-shadow-color);
            box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(--tw-ring-shadow, 0 0 #0000), var(--tw-shadow)
        }

        @media (min-width: 640px) {
            .sm\:flex-col {
                flex-direction: column
            }
        }

        @media (min-width: 768px) {
            .md\:grid-cols-2 {
                grid-template-columns: repeat(2, minmax(0, 1fr))
            }

            .md\:grid-cols-4 {
                grid-template-columns: repeat(4, minmax(0, 1fr))
            }

            .md\:flex-row {
                flex-direction: row
            }
        }

        @media (min-width: 1024px) {
            .lg\:col-span-1 {
                grid-column: span 1 / span 1
            }

            .lg\:flex {
                display: flex
            }

            .lg\:hidden {
                display: none
            }

            .lg\:w-3\/5 {
                width: 60%
            }

            .lg\:max-w-7xl {
                max-width: 80rem
            }

            .lg\:grid-cols-3 {
                grid-template-columns: repeat(3, minmax(0, 1fr))
            }

            .lg\:grid-cols-4 {
                grid-template-columns: repeat(4, minmax(0, 1fr))
            }

            .lg\:flex-row {
                flex-direction: row
            }

            .lg\:text-left {
                text-align: left
            }
        }
    </style>
</head>

<body class="fmax-w-9xl mx-auto">

    <!-- header section -->

    <header class="bg-header-footer-bg text-white">
        <!-- navbar section -->
        <div class="navbar font-bold text-text-color lg:max-w-7xl mx-auto">
            <div class="navbar-start ">

                <img width="200px" src="<?php echo e(img($settings['site_logo'])); ?>" alt="">
            </div>
            <div class="navbar-center hidden lg:flex">
                <ul class="menu menu-horizontal px-1">
                    <li><a>HOME</a></li>
                    <li><a>ABOUT US</a></li>
                    <li><a>CONTACT US</a></li>
                    <?php if(auth()->guard()->guest()): ?>
                        <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('login')); ?>">LOGIN</a></li>
                        <li><a class="btn btn-sm mb-3 bg-text-color text-white" href="<?php echo e(route('register')); ?>">SIGN UP</a>
                        </li>
                        <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('subadmin.login')); ?>">SUB ADMIN</a>
                        </li>
                    <?php else: ?>
                        <?php if($authUser->role == 'admin'): ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                            </li>
                        <?php elseif($authUser->role == 'trainer'): ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <?php elseif($authUser->role == 'tl'): ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <?php elseif($authUser->role == 'stl'): ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('team-leads')); ?>">Dashboard</a></li>
                        <?php elseif($authUser->role == 'counselor'): ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('team-leads')); ?>">Dashboard</a></li>
                        <?php else: ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                        <?php endif; ?>
                    <?php endif; ?>
                </ul>
            </div>
            <div class="navbar-end">
                <div class="dropdown relative">
                    <div id="menu-toggle" class="p-4 lg:hidden" tabindex="0" role="button">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M4 6h16M4 12h8m-8 6h16"></path>
                        </svg>
                    </div>
                    <ul tabindex="0"
                        class="menu menu-sm dropdown-content bg-base-100 rounded-box z-[1] mt-3 w-52 p-2 shadow absolute left-1/2 transform -translate-x-[200px]">
                        <li><a href="/">HOME</a></li>
                        <li><a href="#">ABOUT US</a></li>
                        <li><a href="#">CONTACT US</a></li>
                        <?php if(auth()->guard()->guest()): ?>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('login')); ?>">LOGIN</a></li>
                            <li><a class="btn btn-sm mb-3 bg-text-color text-white" href="<?php echo e(route('register')); ?>">SIGN
                                    UP</a></li>
                            <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('subadmin.login')); ?>">SUB ADMIN</a>
                            </li>
                        <?php else: ?>
                            <?php if($authUser->role == 'admin'): ?>
                                <li><a class="btn btn-sm mb-3 bg-btn-color"
                                        href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                            <?php elseif($authUser->role == 'trainer'): ?>
                                <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                                </li>
                            <?php elseif($authUser->role == 'tl'): ?>
                                <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                                </li>
                            <?php elseif($authUser->role == 'stl'): ?>
                                <li><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('team-leads')); ?>">Dashboard</a>
                                </li>
                            <?php elseif($authUser->role == 'counselor'): ?>
                                <><a class="btn btn-sm mb-3 bg-btn-color" href="<?php echo e(route('team-leads')); ?>">Dashboard</a>
                                <?php else: ?>
                                    <li><a class="btn btn-sm mb-3 bg-btn-color"
                                            href="<?php echo e(route('dashboard')); ?>">Dashboard</a></li>
                            <?php endif; ?>
                        <?php endif; ?>
                    </ul>
                </div>

            </div>
        </div>
        <section class="bg-section-bg flex h-[650px] p-3 hero-bg">
            <div
                class="lg:max-w-7xl mx-auto flex flex-col sm:flex-col md:flex-row lg:flex-row justify-evenly items-center">
                <div>
                    <button class="btn bg-text-color mr-2 text-white text-[25px]"><?php echo e(env('APP_NAME')); ?> </button>
                    <h2 class="text-[25px] font-extrabold text-text-color mt-4">
                        <span class="text-btn-color">Platform</span> <br>
                        
                    </h2>
                    <p class="text-[18px] text-black w-5/6 lg:w-3/5 mt-3 mb-5 ">
                        Transform your valuable free time at home into a simple, smartphone-powered learning and earning
                        journey. Learn in your native tongue and join our community to grow your career.
                    </p>
                    <?php if(auth()->guard()->guest()): ?>
                        <a class="btn bg-text-color text-white" href="<?php echo e(route('login')); ?>">LOGIN</a>
                        <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('register')); ?>">SIGN
                            UP</a>
                    <?php else: ?>
                        <?php if($authUser->role == 'admin'): ?>
                            <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                        <?php elseif($authUser->role == 'trainer'): ?>
                            <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                        <?php elseif($authUser->role == 'tl'): ?>
                            <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                        <?php elseif($authUser->role == 'stl'): ?>
                            <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('team-leads')); ?>">Dashboard</a>
                        <?php elseif($authUser->role == 'counselor'): ?>
                            <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('team-leads')); ?>">Dashboard</a>
                        <?php else: ?>
                            <a class="btn bg-btn-color mr-3 text-white" href="<?php echo e(route('dashboard')); ?>">Dashboard</a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <a class="btn bg-text-color text-white" href="#">Shop Now</a>

                    <a class="btn bg-btn-color mr-3 text-white"
                        href="https://apk.e-droid.net/apk/app3586520-ispeul.apk?v=1">App Download</a>

                </div>
                <div>
                    <img width="80%" src="/assets/home/eeducation-banner.png" alt="">
                </div>
            </div>
        </section>
    </header>

    <!-- main section -->

    <main class=" max-w-9xl mx-auto bg-white">
        <section>
            <div class="grid max-w-7xl mx-auto grid-cols-1 py-16 px-4 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <div class="text-center border border-text-color">
                    <div class="rounded pt-4 text-center">
                        <div class="w-full mt-3">

                            <h1 class="text-xl text-text-color font-semibold">Contact Info</h1>

                            <a class="mx-auto" href="<?php echo e($settings['telegram_link']); ?>">
                                <button class="btn bg-text-color w-full font-bold text-white">Telegram</button> </a>

                            <a class="mx-auto" href="<?php echo e($settings['yt_link']); ?>">
                                <button class="btn bg-btn-color w-full font-bold text-white mt-3"> YouTube </button>
                            </a>

                            <a class="mx-auto" href="<?php echo e($settings['fb_link']); ?>">
                                <button class="btn bg-text-color w-full font-bold text-white">Facebook</button> </a>

                            <img class="w-25 mx-auto rounded-full text-text-color"
                                src="/public/uploads/default/customer-support.png" alt="">


                            



                            <h1 class="text-xl text-text-color font-semibold">SUPPORT TEAM</h1>
                            <?php if(auth()->guard()->check()): ?>
                                <a class="mx-auto" href="https://wa.me/<?php echo e($settings['phone']); ?>">
                                    <button class="btn bg-text-color w-full font-bold text-white">WhatsApp <span
                                            class="pb-2 text-3xl"></span></button> </a>

                                

                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="text-center border border-text-color">
                    <div class="rounded pt-4 text-center">
                        <img class="w-16 mx-auto rounded-full text-text-color"
                            src="/assets/home/pen-khata.jpg" alt="">
                    </div>
                    <h2 class="text-xl text-text-color font-semibold">15+ Courses</h2>
                    <p class="text-black w-5/6 mx-auto pb-6">There are 60+ video classes &amp; live classes, help line
                        for your success</p>
                </div>
                <div class="text-center border border-text-color">
                    <div class="rounded pt-4 text-center">
                        <img class="w-16 mx-auto rounded-full text-text-color"
                            src="/assets/home/teachers.webp" alt="">
                    </div>
                    <h2 class="text-xl text-text-color font-semibold">10+ Teachers</h2>
                    <p class="text-black w-5/6 mx-auto pb-6">
                        With over 20 exceptional teachers dedicated to nurturing your growth.</p>
                </div>
                <div class="text-center border border-text-color">
                    <div class="rounded pt-4 text-center">
                        <img class="w-16 mx-auto rounded-full text-text-color" src="/assets/home/reward.png"
                            alt="">
                    </div>
                    <h2 class="text-xl text-text-color font-semibold">Earn a Certificate</h2>
                    <p class="text-black w-5/6 mx-auto pb-6">
                        Receive a prestigious certificate upon course completion.</p>
                </div>
                <div class="text-center border border-text-color">
                    <div class="rounded pt-4 text-center">
                        <img class="w-16 mx-auto rounded-full text-text-color" src="/assets/home/grad..png"
                            alt="">
                    </div>
                    <h2 class="text-xl text-text-color font-semibold">Achieve Job</h2>
                    <p class="text-black w-5/6 mx-auto pb-6">Open doors to exciting job opportunities with the skills
                        you'll achieve.</p>
                </div>


            </div>
        </section>
        <!-- Courses sections -->
        <section class="bg-section-bg hero-bg">
            <h2 class="text-center font-bold text-4xl text-text-color pt-16">Our Popular Courses</h2>
            <p class="text-black max-w-7xl mx-auto text-center p-3 py-4">Welcome to innovation in learning, where we
                blend Al-Quran studies with web development and digital marketing courses. Enhance your spiritual
                journey and gain essential modern skills, empowering yourself to succeed in both the spiritual and
                digital worlds.Deepen your spiritual connection through Tajweed and Hifz, while mastering modern skills
                like coding and digital marketing for a well-rounded education.</p>
            <div class="max-w-7xl p-4 mx-auto pb-16 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card bg-[#FFFFFF] text-black shadow-xl">
                        <figure class="px-4 pt-4">
                            <img src="<?php echo e(img($c->image)); ?>" alt="<?php echo e($c->name); ?>" class="rounded-xl">
                        </figure>
                        <div class="card-body items-center text-center">
                            <h2 class="card-title">
                                <?php echo e($c->name); ?></h2>
                            <p>
                                <?php echo e($c->description); ?>

                            </p>
                            <div class="w-full mt-3">
                                <?php if(auth()->guard()->guest()): ?>
                                    <button class="btn bg-text-color w-full font-bold text-white">VIEW DETAILS <span
                                            class="pb-2 text-3xl">→</span></button>
                                <?php endif; ?>
                                <?php if(auth()->guard()->check()): ?>
                                    <a class="mx-auto" href="<?php echo e(route('joinClass')); ?>">
                                        <button class="btn bg-btn-color w-full font-bold text-white">JOIN NOW <span
                                                class="pb-2 text-3xl">→</span></button> </a>
                                    <a class="mx-auto" href="<?php echo e(route('studentWorks')); ?>">
                                        <button class="btn bg-text-color w-full font-bold text-white mt-3">WORK SUBMIT<span
                                                class="pb-2 text-3xl">→</span></button></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </section>
        <!-- Join iSmart Ditigal Section -->
        <section class="max-w-7xl text-text-color mx-auto mb-10 text-xl p-3">
            <h2 class="text-4xl font-bold text-center mt-16">Join <?php echo e(env('APP_NAME')); ?> Platform</h2>
            <br>
            <p>Why not take advantage of your free time in a meaningful and productive way? Join our platform and
                kickstart your journey to personal and professional growth.</p>
            <br>
            <br>
            <p>Nowadays, we all have busy lives and often just wish to use our free time at home to relax and unwind.
                However, what if I told you that there is a way to make the most of your downtime, while still growing
                professionally? With our innovative platform, you can transform your valuable free time into a simple,
                smartphone-powered learning and earning journey. Our platform provides courses in your native language,
                allowing you to learn comfortably and at your own pace. Not only will you be able to grow your knowledge
                and skillset, but you will also have the opportunity to connect with fellow learners and professionals
                in our community. By joining our community, you will be able to network, share insights and knowledge,
                and ultimately grow your career.

                Have you been searching for a way to make the most of your idle hours? Instead of letting your free time
                pass by, why not use it in an enriching and constructive manner? You can start your journey towards both
                personal and professional growth by becoming a member of our incredible platform. Our platform offers a
                multitude of resources, tools, and opportunities that can help you hone your skills, gain valuable
                knowledge, and connect with like-minded individuals. By joining us, you can be assured that you are
                investing your time in an endeavor that can bring about positive changes in your life. So why wait?
                Seize this opportunity to expand your horizons and become the best version of yourself. Sign up today
                and unlock a world of possibilities!</p>

        </section>


    </main>

    <!-- footer section -->

    <footer class="custom-footer">
        <div class="custom-container">
            <div class="custom-footer-grid">
                <div class="custom-footer-section custom-footer-logo">
                    <img src="<?php echo e(img($settings['site_logo'])); ?>" alt="Logo">
                    <p>Unlock the power of learning and earning.</p>
                </div>
                <div class="custom-footer-section contact">
                    <h3>Contact Info</h3>
                    <ul>
                        <li><a href="#"><ion-icon name="location" role="img"
                                    class="md hydrated"></ion-icon> <?php echo e($settings['address']); ?></a></li>
                        <li><a href="#"><ion-icon name="call" role="img"
                                    class="md hydrated"></ion-icon> <?php echo e($settings['email']); ?></a></li>
                        <li><a href="#"><ion-icon name="mail" role="img"
                                    class="md hydrated"></ion-icon> <?php echo e($settings['phone']); ?></a></li>
                    </ul>
                </div>
                <div class="custom-footer-section policy">
                    <h3>Policy</h3>
                    <ul>
                        <li><a href="#">Privacy And Policy</a></li>
                        <li><a href="#">Cookie Policy</a></li>
                        <li><a href="#">Terms And Condition</a></li>
                    </ul>
                </div>

                <div class="certificate" style="text-align: center; margin: auto; display: block">
                    <h3><span style="color: #ffffff;">Certificate</span></h3>
                    <a href="#">
                        <img src="https://easyecommerceplatform.com/public/assets/home/easyecommerceplatformx.png"
                            style="width: 300px; height: auto; margin: auto">
                    </a>
                </div>

                <div class="custom-footer-apps">
                    <a href="#"><img src="https://earningsurebd.com/public/ui/assets/google-play-a0292a66.png"
                            alt="Google Play"></a>
                    <a href="#"><img src="https://earningsurebd.com/public/ui/assets/app-store-d5f2c4e8.png"
                            alt="App Store"></a>
                </div>

                <div class="custom-footer-social">
                    <a href="<?php echo e($settings['fb_link']); ?>" class="text-2xl hover:text-blue-500">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                            fill="currentColor">
                            <path
                                d="M12 2C6.477 2 2 6.477 2 12c0 4.991 3.657 9.128 8.438 9.879V14.89h-2.54V12h2.54V9.797c0-2.506 1.492-3.89 3.777-3.89 1.094 0 2.238.195 2.238.195v2.46h-1.26c-1.243 0-1.63.771-1.63 1.562V12h2.773l-.443 2.89h-2.33v6.989C18.343 21.129 22 16.99 22 12c0-5.523-4.477-10-10-10z" />
                        </svg>
                    </a>
                    <a href="<?php echo e($settings['telegram_link']); ?>" class="text-2xl hover:text-blue-400">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                            fill="currentColor">
                            <path
                                d="M11.944 0A12 12 0 0 0 0 12a12 12 0 0 0 12 12 12 12 0 0 0 12-12A12 12 0 0 0 12 0a12 12 0 0 0-.056 0zm4.96 7.18c.285 0 .403.209.339.656l-1.56 10.34c-.113.479-.427.594-.854.369l-3.31-2.531-1.598 1.51c-.18.18-.33.33-.678.33l.24-3.45 6.288-5.671c.27-.24-.058-.375-.406-.135l-7.774 5.793-3.339-1.039c-.47-.15-.479-.47.105-.697l13.012-5.016z" />
                        </svg>
                    </a>
                    <a href="<?php echo e($settings['yt_link']); ?>}}" class="text-2xl hover:text-pink-500">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                            fill="currentColor">
                            <path
                                d="M12 2.162c3.204 0 3.584.012 4.849.07 1.17.054 1.805.249 2.227.415.562.221.96.479 1.378.896.419.419.677.819.896 1.379.164.422.361 1.057.415 2.226.058 1.265.07 1.645.07 4.849s-.012 3.584-.07 4.849c-.054 1.17-.249 1.805-.415 2.227-.221.562-.479.96-.896 1.378-.419.419-.819.677-1.379.896-.422.164-1.057.361-2.226.415-1.265.058-1.645.07-4.849.07s-3.584-.012-4.849-.07c-1.17-.054-1.805-.249-2.227-.415-.562-.221-.96-.479-1.378-.896-.419-.419-.677-.819-.896-1.379-.164-.422-.361-1.057-.415-2.226-.058-1.265-.07-1.645-.07-4.849s.012-3.584.07-4.849c.054-1.17.249-1.805.415-2.227.221-.562.479-.96.896-1.378.419-.419.819-.677 1.379-.896.422-.164 1.057-.361 2.226-.415 1.265-.058 1.645-.07 4.849-.07M12 0C8.741 0 8.332.014 7.053.072 5.775.131 4.902.333 4.14.63c-.79.311-1.459.722-2.126 1.384S.94 3.35.63 4.14C.333 4.902.131 5.775.072 7.053.014 8.332 0 8.741 0 12c0 3.259.014 3.668.072 4.947.059 1.277.261 2.15.558 2.913.306.789.717 1.459 1.384 2.126.667.666 1.336 1.079 2.126 1.384.763.297 1.636.499 2.913.558C8.332 23.986 8.741 24 12 24c3.259 0 3.668-.014 4.947-.072 1.277-.059 2.15-.261 2.913-.558.789-.306 1.459-.718 2.126-1.384.666-.667 1.079-1.335 1.384-2.126.297-.763.499-1.636.558-2.913.058-1.279.072-1.688.072-4.947 0-3.259-.014-3.668-.072-4.947-.059-1.277-.261-2.15-.558-2.913-.306-.789-.718-1.459-1.384-2.126C20.959.84 20.291.428 19.5.122 18.737-.175 17.864-.377 16.587-.436 15.308-.494 14.899-.508 12-.508" />
                            <path
                                d="M12 5.838a6.162 6.162 0 100 12.324 6.162 6.162 0 000-12.324zM12 16a4 4 0 110-8 4 4 0 010 8z" />
                            <circle cx="18.406" cy="5.594" r="1.44" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </footer>
    <p class="flex justify-center bg-copyright-bg text-white">
        <?php echo e(env('APP_NAME')); ?> © <?php echo e(date('Y')); ?>. All Rights Reserved.
    </p>
</body>

</html>
<?php /**PATH /home/easyecommeplatm/public_html/resources/views/welcome.blade.php ENDPATH**/ ?>