<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3">Edit Course</h1>

    <div class="card">
        <form action="<?php echo e(route('admin.courses.update', $course->id)); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name<span class="text-danger">*</span></label>
                        <input type="text" name="name" class="form-control" value="<?php echo e($course->name); ?>" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-danger"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Description</label>
                        <textarea name="description" rows="3" class="form-control"><?php echo e($course->description); ?></textarea>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Image</label>
                        <input type="file" name="image" class="form-control">
                        <?php if($course->image): ?>
                            <small class="d-block mt-1">Current:
                                <img src="<?php echo e(asset('storage/' . $course->image)); ?>" height="80">
                            </small>
                        <?php endif; ?>
                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-danger"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Button Link</label>
                        <input type="text" name="btn_link" class="form-control" value="<?php echo e($course->btn_link); ?>">
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Work Submission<span class="text-danger">*</span></label>
                        <select name="work_submit" class="form-select" required>
                            <option value="1" <?php echo e($course->work_submit ? 'selected' : ''); ?>>Enabled</option>
                            <option value="0" <?php echo e($course->work_submit ? '' : 'selected'); ?>>Disabled</option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Commission<span class="text-danger">*</span></label>
                        <input type="number" step="any" min="0" name="commission" class="form-control"
                            value="<?php echo e($course->commission); ?>" required>
                    </div>
                </div>

            </div>

            <div class="card-footer d-flex justify-content-between">
                <a href="<?php echo e(route('admin.courses.index')); ?>" class="btn btn-dark">Back</a>
                <button type="submit" type="submit" class="btn btn-primary">Save</button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/munfashion/public_html/resources/views/backend/courses/edit.blade.php ENDPATH**/ ?>