<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo e(isset($title) ? $title . ' - ' : ''); ?><?php echo e(config('app.name')); ?></title>

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@mdi/font@7.4.47/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/feather/feather.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/ti-icons/css/themify-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/css/vendor.bundle.base.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/font-awesome/css/font-awesome.min.css')); ?>">
    <?php echo ToastMagic::styles(); ?>

    <?php echo $__env->yieldPushContent('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vertical-layout-light/style.css')); ?>">
</head>

<body>
    <?php
        $user = Auth::user()
    ?>
    <div class="container-scroller">
        <!-- partial:../../partials/_navbar.html -->
        <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
            <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-start">
                <a class="navbar-brand brand-logo me-5" href="/"><img
                        src="<?php echo e(img($settings['site_logo'])); ?>" class="me-2"
                        alt="logo" /></a>
                <a class="navbar-brand brand-logo-mini" href="/"><img
                        src="<?php echo e(img($settings['mobile_logo'])); ?>"
                        alt="logo" /></a>
            </div>
            <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end">
                <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
                    <span class="icon-menu"></span>
                </button>
                <ul class="navbar-nav mr-lg-2">
                    <li class="nav-item nav-search d-none d-lg-block">
                        <div class="input-group">
                            <div class="input-group-prepend hover-cursor" id="navbar-search-icon">
                                <span class="input-group-text" id="search">
                                    <i class="icon-search"></i>
                                </span>
                            </div>
                            <input type="text" class="form-control" id="navbar-search-input" placeholder="Search now"
                                aria-label="search" aria-describedby="search">
                        </div>
                    </li>
                </ul>
                <ul class="navbar-nav navbar-nav-right">
                    <li class="nav-item nav-profile dropdown">
                        <a class="nav-link dropdown-toggle" href="#" data-bs-toggle="dropdown"
                            id="profileDropdown">
                            <img src="<?php echo e(img($user->avatar)); ?>" alt="avatar" />
                        </a>
                        <div class="dropdown-menu dropdown-menu-right navbar-dropdown"
                            aria-labelledby="profileDropdown">
                            <a href="<?php echo e(route('profile')); ?>" class="dropdown-item">
                                <i class="ti-settings text-primary"></i>
                                Settings
                            </a>
                            <a class="dropdown-item" href="javascript:void(0)" onclick="document.getElementById('logout-form').submit()">
                                <i class="ti-power-off text-primary"></i>
                                Logout
                            </a>
                            <form action="<?php echo e(route('logout')); ?>" method="post" id="logout-form"><?php echo csrf_field(); ?></form>
                        </div>
                    </li>
                    <li class="nav-item nav-settings d-none d-lg-flex">
                        <a class="nav-link" href="#">
                            <i class="icon-ellipsis"></i>
                        </a>
                    </li>
                </ul>
                <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button"
                    data-toggle="offcanvas">
                    <span class="icon-menu"></span>
                </button>
            </div>
        </nav>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:../../partials/_sidebar.html -->
            <nav class="sidebar sidebar-offcanvas" id="sidebar">
                <ul class="nav">
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('dashboard')); ?>">
                            <i class="icon-grid menu-icon"></i>
                            <span class="menu-title">Dashboard</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('referral')); ?>">
                            <i class="icon-link menu-icon"></i>
                            <span class="menu-title">Referral</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('passbook')); ?>">
                            <i class="ti-receipt menu-icon"></i>
                            <span class="menu-title">My Passbook</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('withdrawal')); ?>">
                            <i class="ti-money menu-icon"></i>
                            <span class="menu-title">Withdrawals</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(route('profile')); ?>">
                            <i class="ti-user menu-icon"></i>
                            <span class="menu-title">Profile</span>
                        </a>
                    </li>
                    <?php if($user->role == 'student'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('joinClass')); ?>">
                                <i class="ti-arrow-right menu-icon"></i>
                                <span class="menu-title">Join Class</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('studentWorks')); ?>">
                                <i class="ti-help-alt menu-icon"></i>
                                <span class="menu-title">Work Submit</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(in_array($user->role, ['trainer', 'teacher'])): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('works')); ?>">
                                <i class="ti-time menu-icon"></i>
                                <span class="menu-title">Work Submissions</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('classLinks')); ?>">
                                <i class="ti-link menu-icon"></i>
                                <span class="menu-title">Class Links</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if($user->role == 'manager'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('users.search')); ?>">
                                <i class="ti-search menu-icon"></i>
                                <span class="menu-title">Search Students</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('users.index')); ?>">
                                <i class="ti-user menu-icon"></i>
                                <span class="menu-title">Students</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(in_array($user->role, ['tl', 'stl'])): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('teachers')); ?>">
                                <i class="ti-user menu-icon"></i>
                                <span class="menu-title">Teachers</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('trainers')); ?>">
                                <i class="ti-user menu-icon"></i>
                                <span class="menu-title">Trainers</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if($user->role == 'stl'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('teamLeaders')); ?>">
                                <i class="ti-user menu-icon"></i>
                                <span class="menu-title">Team Leaders</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if($user->role == 'counselor'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('seniorTeamLeaders')); ?>">
                                <i class="ti-user menu-icon"></i>
                                <span class="menu-title">Senior Team Leaders</span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if(in_array($user->role, ['trainer','teacher','tl', 'stl', 'counselor'])): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('students')); ?>">
                                <i class="ti-user menu-icon"></i>
                                <span class="menu-title">Active Students</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo e(route('team-leads')); ?>">
                                <i class="ti-unlink menu-icon"></i>
                                <span class="menu-title">Team Leads</span>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
                <!-- content-wrapper ends -->
                <!-- partial:../../partials/_footer.html -->
                <footer class="footer">
                    <div class="d-sm-flex justify-content-center justify-content-sm-between">
                        <span class="text-muted text-center text-sm-left d-block d-sm-inline-block">Copyright © 2025. All rights reserved.</span>
                    </div>
                </footer>
                <!-- partial -->
            </div>
            <!-- main-panel ends -->
        </div>
        <!-- page-body-wrapper ends -->
    </div>
    <!-- container-scroller -->

    <script src="<?php echo e(asset('assets/vendors/js/vendor.bundle.base.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/hoverable-collapse.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/template.js')); ?>"></script>
    <?php echo ToastMagic::scripts(); ?>

    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/easyecommeplatm/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>