<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Login - <?php echo e(config('app.name')); ?></title>

    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/ti-icons/css/themify-icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/vertical-layout-light/style.css')); ?>">

    <?php echo ToastMagic::styles(); ?>


</head>

<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center">
                <div class="card shadow-lg border-0 rounded-4">
                    <div class="card-body p-4">
                        <div class="mb-4">
                            <i class="ti-lock text-warning" style="font-size: 48px;"></i>
                        </div>
                        <h3 class="mb-3">Account Inactive</h3>
                        <p class="text-muted mb-4">Your account is currently inactive. Please complete the payment to
                            activate and continue using our services.</p>

                        <div class="row">
                            <div class="col-md-6">
                                <h5 class="mb-3">Contact Admin</h5>
                                <ul class="list-unstyled mb-4">
                                    <li><strong>Email:</strong> <?php echo e($settings['email']); ?></li>
                                    <li><strong>Phone:</strong> <?php echo e($settings['phone']); ?></li>
                                    <li><strong>WhatsApp:</strong> <a
                                            href="https://wa.me/88<?php echo e($settings['phone']); ?>?text=<?php echo e(wp_msg($user)); ?>"
                                            target="_blank">Chat Now</a></li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <h5 class="mb-3">My Info</h5>
                                <ul class="list-unstyled mb-4">
                                    <li><strong>ID:</strong> <?php echo e($user->id); ?></li>
                                    <li><strong>Name:</strong> <?php echo e($user->name); ?></li>
                                    <li><strong>Phone:</strong> <?php echo e($user->phone); ?></li>
                                    <li><strong>Refer By:</strong> <?php echo e($user->referer?->name); ?></li>
                                    <li><strong>Joining Date:</strong> <?php echo e($user->created_at->format('d M Y')); ?></li>
                                </ul>
                            </div>
                        </div>

                        <?php if($user->payment_status == 'unpaid'): ?>
                            <?php if($settings['payment_gateway']): ?>
                                <form action="<?php echo e(route('activation')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        Activate Now
                                    </button>
                                </form>
                            <?php endif; ?>
                        <?php else: ?>
                            <a href="javascript:void(0)" class="btn btn-success btn-lg">
                                PAID
                            </a>
                        <?php endif; ?>

                        <a class="btn btn-dark mt-3" href="javascript:void(0)" onclick="document.getElementById('logout-form').submit()">
                            <i class="ti-power-off text-primary"></i>
                            Logout
                        </a>
                        <form action="<?php echo e(route('logout')); ?>" method="post" id="logout-form"><?php echo csrf_field(); ?></form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html><?php /**PATH /home/theearn1/public_html/resources/views/activation.blade.php ENDPATH**/ ?>