

<?php $__env->startSection('content'); ?>
<h3 class="mb-4">All Class Links</h3>

    <div class="card">
        <div class="card-header">
            <?php if($course): ?>
                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">Add New</button>
            <?php endif; ?>
        </div>
        <div class="card-body">

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php echo e($i->course?->name); ?>

                                </td>
                                <td>
                                    <a target="_blank" href="<?php echo e($i->link); ?>" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td>
                                    <?php echo e($i->time->format('d M Y, h:i a')); ?>

                                </td>
                                <td>
                                    <button class="btn btn-sm btn-danger" onclick="deleteData(<?php echo e($i->id); ?>)">
                                        <i class="ti-trash text-white"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($links->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>

    <?php if($course): ?>
        <!-- Modal -->
        <div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <form action="<?php echo e(route('classLinks')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-content">
                        <div class="modal-header">
                            <h1 class="modal-title fs-5" id="addModalLabel">Add new class link</h1>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label for="" class="form-label">Course</label>
                                <select name="course" class="form-select" required>
                                    <option value="<?php echo e($course->id); ?>" selected><?php echo e($course->name); ?></option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="" class="form-label">Link</label>
                                <input type="text" name="link" class="form-control form-control-sm" required>
                            </div>
                            <div class="mb-3">
                                <label for="" class="form-label">Time</label>
                                <input type="datetime-local" name="time" class="form-control form-control-sm" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>

    <form action="" method="post" id="delete-form"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?></form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        const deleteForm = document.getElementById('delete-form');

        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored");
            if (ask) {
                deleteForm.action = window.location.origin + window.location.pathname + '/' + id;
                deleteForm.submit();
            }
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/trainer_teacher/class_links.blade.php ENDPATH**/ ?>