

<?php $__env->startSection('content'); ?>
    <h3 class="mb-4">Active Students</h3>
    <div class="card">
        <div class="card-body">
            <form action="" method="get">
            <div class="row mb-3">
                    <div class="col-8">
                        <input type="text" name="query" class="form-control form-control-sm" placeholder="student id or phone number"
                        value="<?php echo e(request('query')); ?>">
                    </div>
                    <div class="col-4">
                        <button class="btn btn-dark">Search</button>
                    </div>
                </div>
            </form>
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Trainer</th>
                            <th>Teacher</th>
                            <th>Status</th>
                            <th>WhatsApp</th>
                            <?php if($user->role == 'tl'): ?>
                            <th>Action</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($student->user?->id); ?></td>
                                <td><img src="<?php echo e(img($student->user?->avatar)); ?>" width="60" class="rounded-circle"></td>
                                <td><?php echo e($student->user?->name); ?></td>
                                <td><?php echo e($student->trainer?->name); ?></td>
                                <td><?php echo e($student->teacher?->name); ?></td>
                                <td>
                                    <?php if($student->user?->status): ?>
                                        <span class="badge bg-primary">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Blocked</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="https://wa.me/<?php echo e($student->user?->phone); ?>?text=<?php echo e(wp_msg($student->user)); ?>" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                                <?php if($user->role == 'tl'): ?>
                                <td>
                                    <a href="<?php echo e(route('students.edit', $student->user?->id)); ?>" class="btn btn-primary btn-sm">
                                        <i class="ti-pencil"></i>
                                    </a>
                                </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($students->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/oursopno/smm.oursopnozonebd.top/resources/views/students.blade.php ENDPATH**/ ?>