

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/css/intlTelInput.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendors/select2/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h3 class="mb-4">Edit student</h3>
        <a href="<?php echo e(request('source') ?? url()->previous()); ?>" class="btn btn-secondary">Back</a>
    </div>

    <div class="card">
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('users.update', $user->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="phone" value="<?php echo e($user->phone); ?>">
                <input type="hidden" name="source" value="<?php echo e(request('source')); ?>">

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Name*</label>
                        <input type="text" name="name" class="form-control form-control-sm" required value="<?php echo e($user->name); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Phone*</label>
                        <input type="text" id="phone" class="form-control form-control-sm" required value="<?php echo e($user->phone); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control form-control-sm" value="<?php echo e($user->email); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Gender</label>
                        <select name="gender" class="form-select">
                            <option value="">Select</option>
                            <option value="male" <?php echo e($user->gender == 'male' ? 'selected' : ''); ?>>Male</option>
                            <option value="female" <?php echo e($user->gender == 'female' ? 'selected' : ''); ?>>Female</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Address</label>
                        <input type="text" name="address" class="form-control form-control-sm" value="<?php echo e($user->address); ?>">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Password</label>
                        <input type="password" name="password" class="form-control form-control-sm">
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Payment Status</label>
                        <select name="payment_status" class="form-select">
                            <option value="unpaid" <?php echo e($user->payment_status == 'unpaid' ? 'selected' : ''); ?>>Unpaid
                            </option>
                            <option value="paid" <?php echo e($user->payment_status == 'paid' ? 'selected' : ''); ?>>Paid</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="1" <?php echo e($user->status ? 'selected' : ''); ?>>Active</option>
                            <option value="0" <?php echo e(!$user->status ? 'selected' : ''); ?>>Blocked</option>
                        </select>
                    </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Counselor*</label>
                            <select name="counselor" id="counselor" class="select2 w-100" required>
                                <option value="" selected>Select Option</option>
                                    <?php
                                        $tl = $user->teamLeaderOfStudent;
                                        $stl = $tl?->seniorTeamLeader;
                                        $counselor = $stl?->counselor;
                                    ?>
                                    <?php $__currentLoopData = $counselors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cn->id); ?>"
                                            <?php echo e($counselor?->id == $cn->id ? 'selected' : ''); ?>><?php echo e($cn->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Senior Team Leader*</label>
                            <select name="stl" class="select2 w-100" id="stl" required>
                                <?php if($stl): ?>
                                    <option value="<?php echo e($stl?->id); ?>" selected><?php echo e($stl?->name); ?></option>
                                <?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Team Leader*</label>
                            <select name="tl" class="select2 w-100" id="tl" required>
                                <?php if($tl): ?>
                                    <option value="<?php echo e($tl?->id); ?>" selected><?php echo e($tl?->name); ?></option>
                                <?php endif; ?>
                            </select>
                        </div>
                    <div class="col-12 mt-4">
                        <button class="btn btn-primary">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('assets/vendors/select2/select2.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/intlTelInput.min.js"></script>
    <script>
        $('.select2').select2()
        intlTelInput(document.getElementById("phone"), {
            loadUtils: () => import("https://cdn.jsdelivr.net/npm/intl-tel-input@25.3.1/build/js/utils.js"),
            initialCountry: "bd",
            containerClass: "w-100",
            nationalMode: true,
            hiddenInput: (telInputName) => ({
                phone: "phone",
            }),
        })
        $("#counselor").on("change", function(e) {
            if ($("#stl")[0]) {
                $.ajax({
                    type: "GET",
                    url: `/users/${e.target.value}/stls`,
                    success: function(response) {
                        let html = `<option value="">Select option</option>`
                        $.each(response, function(indexInArray, valueOfElement) {
                            if (valueOfElement.user) {
                                html +=
                                    `<option value="${valueOfElement.user.id}">${valueOfElement.user.name}</option>`
                            }
                        });
                        $("#stl").html(html)
                    }
                });
            }
        });
        $("#stl").on("change", function(e) {
            if ($("#tl")[0]) {
                $.ajax({
                    type: "GET",
                    url: `/users/${e.target.value}/tls`,
                    success: function(response) {
                        let html = `<option value="">Select option</option>`
                        $.each(response, function(indexInArray, valueOfElement) {
                            if (valueOfElement.user) {
                                html +=
                                    `<option value="${valueOfElement.user.id}">${valueOfElement.user.name}</option>`
                            }
                        });
                        $("#tl").html(html)
                    }
                });
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/manager/edit_student.blade.php ENDPATH**/ ?>