

<?php $__env->startSection('content'); ?>
<h3 class="mb-4">Work Submit</h3>

    <div class="card">
        <div class="card-body">
            <h5 class="text-info mb-3">Total Limit: <?php echo e($settings['total_work_limit']); ?></h5>
            <h5 class="text-info mb-3">Per Day Per Course Limit: <?php echo e($settings['per_day_per_course_work_limit']); ?></h5>

            <div class="mb-4">
                <form action="<?php echo e(route('studentWorks')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Course</label>
                                    <select name="course" class="form-select" required>
                                        <option value="">Select</option>
                                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($c->id); ?>"><?php echo e($c->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Link</label>
                                    <input type="text" name="link" class="form-control form-control-sm" required>
                                </div>
                                <div class="col-md-12 mb-3">
                                    <label class="form-label">Note</label>
                                    <textarea name="note" rows="2" class="form-control"></textarea>
                                </div>
                                <div class="col-12">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        
                </form>
            </div>

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Date</th>
                            <th>Course</th>
                            <th>Link</th>
                            <th>Note</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($i->created_at->format('d M Y')); ?></td>
                                <td><?php echo e($i->course?->name); ?></td>
                                <td>
                                    <a target="_blank" href="<?php echo e($i->link); ?>" class="btn btn-sm btn-primary">Click</a>
                                </td>
                                <td><?php echo e($i->note); ?></td>
                                <td>
                                    <?php if($i->status == 'pending'): ?>
                                        <span class="badge bg-warning">Pending</span>
                                    <?php elseif($i->status == 'approved'): ?>
                                        <span class="badge bg-success">Approved</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Declined</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($works->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/student/work-submit.blade.php ENDPATH**/ ?>