<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3">All Courses</h1>

    <div class="card">
        <div class="card-header">
            <a href="<?php echo e(route('admin.courses.create')); ?>" class="btn btn-primary">Add New</a>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>
                                <i class="align-middle" data-feather="image"></i>
                            </th>
                            <th>Name</th>
                            <th>Commission</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <img src="<?php echo e(img($i->image)); ?>" width="80">
                                </td>
                                <td>
                                    <?php echo e($i->name); ?>

                                </td>
                                <td>
                                    <?php echo e($i->work_submit ? $i->commission : '-'); ?>

                                </td>
                                <td>
                                    <a href="<?php echo e(route('admin.courses.edit', $i->id)); ?>" class="btn btn-info">
                                        <i class="align-middle" data-feather="edit"></i>
                                    </a>
                                    <button class="btn btn-danger" onclick="deleteData(<?php echo e($i->id); ?>)">
                                        <i class="align-middle" data-feather="trash"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <?php echo e($courses->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>

    <form action="" method="post" id="delete-form"><?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?></form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        const deleteForm = document.getElementById('delete-form');

        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored");
            if (ask) {
                deleteForm.action = window.location.origin + window.location.pathname + '/' + id;
                deleteForm.submit();
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/easyecommeplatm/public_html/resources/views/backend/courses/index.blade.php ENDPATH**/ ?>