

<?php $__env->startSection('content'); ?>
<h3 class="mb-4">My Referral Code</h3>
    <div class="card">
        <div class="card-body">
            <h5 class="text-muted mb-3">Student ID: <strong><?php echo e($user->id); ?></strong></h5>

            <div class="mb-4">
                <label class="form-label" for="referralURL">Referral Link</label>
                <div class="input-group">
                    <input type="text" value="<?php echo e(route('register', ['reference' => $user->id])); ?>" class="form-control"
                        id="referralURL" readonly>
                    <button class="btn btn-outline-primary" id="copyBoard"><i class="ti-clipboard"></i></button>
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-light text-danger">
                        <strong>Total Leads:</strong> <?php echo e($totalLeads); ?>

                    </div>
                </div>
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-light text-danger">
                        <strong>Today's Leads:</strong> <?php echo e($todayLeads); ?>

                    </div>
                </div>
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-success text-white">
                        <strong>Total Converted:</strong> <?php echo e($totalConverted); ?>

                    </div>
                </div>
                <div class="col-md-3 col-6 mb-2">
                    <div class="p-3 border rounded bg-success text-white">
                        <strong>Today's Converted:</strong> <?php echo e($todayConverted); ?>

                    </div>
                </div>
            </div>            

            <h5 class="mb-3">All Leads</h5>

            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Student ID</th>
                            <th>Name</th>
                            <th>Joining Date</th>
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($lead->id); ?></strong></td>
                                <td><?php echo e($lead->name); ?></td>
                                <td><?php echo e($lead->created_at->format('d M Y')); ?></td>
                                <td>
                                    <a href="https://wa.me/<?php echo e($lead->phone); ?>?text=<?php echo e(wp_msg($lead)); ?>" target="_blank" class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($leads->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script>
    document.getElementById('copyBoard').addEventListener('click', function () {
        const input = document.getElementById('referralURL');
        input.select();
        input.setSelectionRange(0, 99999);

        try {
            const success = document.execCommand('copy');
            if (success) {
                toastMagic.success('Referral link copied to clipboard!');
            } else {
                toastMagic.error('Failed to copy referral link.');
            }
        } catch (err) {
            toastMagic.error('Oops! Unable to copy.');
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/munfashion/public_html/resources/views/referral.blade.php ENDPATH**/ ?>