

<?php $__env->startSection('content'); ?>
    <h1 class="h3 mb-3">Withdrawals List</h1>

    <div class="card mb-4">
        <div class="card-header">
            <div class="row">
                <div class="col-md-12 mb-3">
                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('admin.withdrawals', ['status' => $status])); ?>"
                            class="btn btn-outline-success btn-sm mr-2 mb-2 <?php echo e(request('status') == $status ? 'btn-success text-light' : ''); ?>"><?php echo e(strtoupper($status)); ?></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <div class="card-body table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Amount</th>
                        <th>Details</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $withdrawals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdrawal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                ID: <strong><?php echo e($withdrawal->user?->id); ?></strong> <br>
                                Name: <?php echo e($withdrawal->user?->name); ?> <br>
                                <i data-feather="phone"></i> <?php echo e($withdrawal->user?->phone); ?>

                            </td>
                            <td>৳<?php echo e($withdrawal->amount); ?></td>
                            <?php
                                $details = json_decode($withdrawal->details, true);
                            ?>
                            <td>
                                <ul class="mb-0 list-style-none">
                                    <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><strong><?php echo e(ucwords(str_replace('_', ' ', $key))); ?>:</strong> <?php echo e($value); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </td>
                            <td><?php echo e($withdrawal->created_at->format('d M Y')); ?></td>
                            <td>
                                <?php if($withdrawal->status == 'approved'): ?>
                                    <span class="badge bg-success">Approved</span>
                                <?php elseif($withdrawal->status == 'declined'): ?>
                                    <span class="badge bg-danger">Declined</span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($withdrawal->status == 'pending'): ?>
                                    <div class="btn-group">
                                        <button class="btn btn-sm btn-success" onclick="deleteData(<?php echo e($withdrawal->id); ?>, 'approved')">
                                            <i data-feather="check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteData(<?php echo e($withdrawal->id); ?>, 'declined')">
                                            <i data-feather="x"></i>
                                        </button>
                                    </div>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="p-3">
                <?php echo e($withdrawals->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>

    
    <form action="<?php echo e(route('admin.withdrawals')); ?>" method="post" id="status-form">
        <input type="hidden" name="id" id="user_id">
        <input type="hidden" name="status" id="status">
        <?php echo csrf_field(); ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function deleteData(id, status) {
            let ask = confirm("Status can't be restored!")
            if (ask) {
                $("#user_id").val(id)
                $("#status").val(status)
                $("#status-form").submit();
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/munfashion/public_html/resources/views/backend/withdrawals/index.blade.php ENDPATH**/ ?>