

<?php $__env->startSection('content'); ?>
    <div class="d-flex align-items-center justify-content-between mb-3">
        <h3 class="mb-4">Profile - <?php echo e($user->name); ?> [#<?php echo e($user->id); ?>]</h3>
        <a href="<?php echo e(request('source') ?? url()->previous()); ?>" class="btn btn-secondary">Back</a>
    </div>

    <div class="row">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <img src="<?php echo e(img($user->avatar)); ?>" class="rounded-circle mb-3" widivh="120" height="120"
                        alt="Avatar">
                    <h5 class="card-title"><?php echo e($user->name); ?></h5>
                    <p class="text-muted mb-1"><?php echo e(ucfirst($user->role)); ?></p>
                    <span class="badge bg-<?php echo e($user->payment_status == 'paid' ? 'success' : 'danger'); ?>">
                        <?php echo e(ucfirst($user->payment_status)); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="card shadow-sm">
                <div class="card shadow-sm">
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-4">Student ID</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e($user->id); ?></dd>

                            <dt class="col-sm-4">Phone</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e($user->phone); ?></dd>

                            <dt class="col-sm-4">Email</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e($user->email ?? '-'); ?></dd>

                            <dt class="col-sm-4">Gender</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e(ucfirst($user->gender ?? '-')); ?></dd>

                            <dt class="col-sm-4">Address</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e($user->adivress ?? '-'); ?></dd>

                            <dt class="col-sm-4">Refer By</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e($user->referer?->name ?? '-'); ?></dd>

                            <dt class="col-sm-4">Social Link</dt>
                            <dd class="col-sm-8 mb-2">
                                <?php if($user->social_link): ?>
                                    <a href="<?php echo e($user->social_link); ?>" target="_blank"><?php echo e($user->social_link); ?></a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </dd>

                            <dt class="col-sm-4">Activation Date</dt>
                            <dd class="col-sm-8 mb-2">
                                <?php echo e($user->verified_at ? $user->verified_at->format('d M Y, h:i A') : 'Not Activated'); ?>

                            </dd>

                            <dt class="col-sm-4">Balance</dt>
                            <dd class="col-sm-8 mb-2">৳<?php echo e(number_format($user->balance, 2)); ?></dd>

                            <dt class="col-sm-4">Pending Fee Date</dt>
                            <dd class="col-sm-8 mb-2"><?php echo e($user->pending_fee ? $user->pending_fee->format('d M Y') : '-'); ?>

                            </dd>

                            <dt class="col-sm-4">Last Withdraw</dt>
                            <dd class="col-sm-8 mb-2">
                                <?php echo e($user->last_withdraw ? $user->last_withdraw->format('d M Y') : '-'); ?></dd>

                            <dt class="col-sm-4">Status</dt>
                            <dd class="col-sm-8 mb-2">
                                <span class="badge bg-<?php echo e($user->status ? 'success' : 'danger'); ?>">
                                    <?php echo e($user->status ? 'Active' : 'Blocked'); ?>

                                </span>
                            </dd>
                        </dl>

                        <?php if(in_array($role, ['stl', 'tl', 'trainer', 'teacher', 'student'])): ?>
                            <hr>
                            <dl class="row">
                                <?php
                                    $tl = $user->teamLeaderOfStudent;
                                    $stl = $tl->seniorTeamLeader;
                                    $counselor = $stl?->counselor;                                                                        
                                ?>


                                <dt class="col-sm-4">Counselor</dt>
                                <dd class="col-sm-8 mb-2"><?php echo e($counselor?->name); ?> [<?php echo e($counselor?->phone); ?>]</dd>

                                <?php if($stl): ?>
                                    <dt class="col-sm-4">Senior Team Leader</dt>
                                    <dd class="col-sm-8 mb-2"><?php echo e($stl->name); ?> [<?php echo e($stl->phone); ?>]</dd>
                                <?php endif; ?>

                                <?php if($tl): ?>
                                    <dt class="col-sm-4">Team Leader</dt>
                                    <dd class="col-sm-8 mb-2"><?php echo e($tl->name); ?> [<?php echo e($tl->phone); ?>]</dd>
                                <?php endif; ?>

                                <?php if($user->student?->trainer): ?>
                                    <dt class="col-sm-4">Trainer</dt>
                                    <dd class="col-sm-8 mb-2"><?php echo e($user->student->trainer?->name); ?>

                                        [<?php echo e($user->student->trainer?->phone); ?>]</dd>
                                <?php endif; ?>

                                <?php if($user->student?->teacher): ?>
                                    <dt class="col-sm-4">Teacher</dt>
                                    <dd class="col-sm-8 mb-2"><?php echo e($user->student->teacher?->name); ?>

                                        [<?php echo e($user->student->teacher?->phone); ?>]</dd>
                                <?php endif; ?>
                            </dl>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/manager/student-details.blade.php ENDPATH**/ ?>