

<?php $__env->startSection('content'); ?>
<?php
    $url = Request::getRequestUri();
?>
    <h3 class="mb-4">Search Students</h3>
    <div class="card">
        <div class="card-header">
            <form action="" method="get">
                <div class="row mb-3">
                    <div class="col-8">
                        <input type="text" name="search" class="form-control form-control-sm" placeholder="Search by ID or phone number"
                            value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-3">
                        <button type="button" class="btn btn-primary">Search</button>
                    </div>
                </div>
            </form>
            <form action="" method="get">
                <div class="row">
                    <div class="col-md-3 col-6">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select" required>
                            <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                        </select>
                    </div>
                    <div class="col-md-3 col-6">
                        <label class="form-label">From</label>
                        <input type="date" name="from" value="<?php echo e(request('from')); ?>" class="form-control form-control-sm" required>
                    </div>
                    <div class="col-md-3 col-6">
                        <label class="form-label">To</label>
                        <input type="date" name="to" value="<?php echo e(request('to')); ?>" class="form-control form-control-sm" required>
                    </div>
                    <div class="col-md-3 col-6 mt-4">
                        <button type="submit" class="btn btn-dark">Filter</button>
                    </div>
                </div>
            </form>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Image</th>
                            <th>Details</th>
                            <th>Status</th>
                            <th>Balance</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <img src="<?php echo e(img($user->avatar)); ?>" width="60" class="rounded-circle">
                            </td>
                            <td>
                                <span class="d-block mb-1">ID: <?php echo e($user->id); ?></span>
                                <span class="d-block mb-1">Name: <?php echo e($user->name); ?></span>
                                <span class="d-block mb-1">Email: <?php echo e($user->email); ?></span>
                                <span class="d-block mb-1">Phone: <?php echo e($user->phone); ?> </span>
                                <span class="d-block mb-1">Refer By: <?php echo e($user->referer?->name); ?>(<?php echo e($user->referer?->id); ?>) </span>
                                <a href="https://wa.me/<?php echo e($user->phone); ?>?text=<?php echo e(wp_msg($user)); ?>" target="_blank"
                                    class="btn btn-sm btn-dark">WhatsApp</a>
                            </td>
                            <td>
                                <?php if($user->verified_at): ?>
                                    <?php if($user->status): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Blocked</span>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span>৳<?php echo e($user->balance); ?></span> <br>
                                <button class="btn btn-sm btn-info"
                                    onclick="loadModal(<?php echo e($user->id); ?>)">Wallet</button>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <?php if($user->verified_at): ?>
                                        <a href="<?php echo e(route('users.edit', ['user' => $user->id, 'source' => $url])); ?>"
                                            class="btn btn-sm btn-primary">
                                            <i class="ti-pencil"></i>
                                        </a>
                                        <a href="<?php echo e(route('users.show', ['user' => $user->id, 'source' => $url])); ?>"
                                            class="btn btn-sm btn-warning">
                                            <i class="ti-eye"></i>
                                        </a>
                                    <?php else: ?>
                                        <a href="<?php echo e(route('users.edit', ['user' => $user->id, 'source' => $url])); ?>"
                                            class="btn btn-sm btn-primary">
                                            Approved
                                        </a>
                                    <?php endif; ?>
                                    <button class="btn btn-sm btn-danger text-white" onclick="deleteData(<?php echo e($user->id); ?>)">
                                        <i class="ti-trash"></i>
                                    </button>
                                </div>
                            </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($users->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="walletModal" tabindex="-1" aria-labelledby="walletModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="<?php echo e(route('updateBalance')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="walletModalLabel">Update Balance</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" id="user_id">
                        <input name="amount" type="number" step="any" min="1"
                            class="mb-3 form-control form-control-sm" required placeholder="amount">
                        <select name="type" class="mb-3 form-select" required>
                            <option value="credit">Cash in</option>
                            <option value="debit">Cash out</option>
                        </select>
                        <input name="details" type="text" class="mb-3 form-control form-control-sm" placeholder="details"
                            required>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <form action="#" method="post" id="delete-form">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function deleteData(id) {
            let ask = confirm("Deleted file can't be restored!")
            if (ask) {
                $("#delete-form").attr('action', `<?php echo e(route('users.index')); ?>/${id}`);
                $("#delete-form").submit();
            }
        }
        const myModal = new bootstrap.Modal("#walletModal")

        function loadModal(id) {
            $("#user_id").val(id)
            myModal.show()
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/manager/search_student.blade.php ENDPATH**/ ?>