

<?php $__env->startSection('content'); ?>
    <h3 class="mb-4">All Team Leads</h3>
    <div class="card">
        <div class="card-body">
            <form action="" method="get">
                <div class="row mb-3">
                    <div class="row">
                        <div class="col-md-3">
                            <label class="form-label" for="type">Type</label>
                            <select name="type" required class="form-select">
                                <option value="1" <?php echo e(request('type') == 1 ? 'selected' : ''); ?>>Converted</option>
                                <option value="0" <?php echo e(request('type') == 0 ? 'selected' : ''); ?>>Leads</option>
                            </select>

                        </div>
                        <div class="col-md-3">
                            <label class="form-label" for="from">From</label>
                            <input type="date" name="from" class="form-control form-control-sm"
                                value="<?php echo e(request('from')); ?>" required />
                        </div>
                        <div class="col-md-3">
                            <label class="form-label" for="to">To</label>
                            <input type="date" name="to" class="form-control form-control-sm"
                                value="<?php echo e(request('to')); ?>" required />
                        </div>
                        <div class="col-md-3">
                            <button type="submit" class="btn btn-dark mt-4">Search Leads</button>
                        </div>
                    </div>
                </div>
            </form>
            <div class="mb-3 text-danger">
                Total Results: <?php echo e($leads->total()); ?> <br>
            </div>
            <div class="table-responsive">
                <table class="table table-stripped">
                    <thead class="table-light">
                        <tr>
                            <th>Student ID</th>
                            <th>Name</th>
                            <th>Refer By</th>
                            <th>Joining Date</th>
                            <th>WhatsApp</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($lead->id); ?></strong></td>
                                <td><?php echo e($lead->name); ?></td>
                                <td><?php echo e($lead->referer?->name); ?></td>
                                <td><?php echo e($lead->created_at->format('d M Y')); ?></td>
                                <td>
                                    <a href="https://wa.me/<?php echo e($lead->phone); ?>?text=<?php echo e(wp_msg($lead)); ?>" target="_blank"
                                        class="btn btn-sm btn-dark">WhatsApp</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mt-3">
                    <?php echo e($leads->links('pagination::bootstrap-5')); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/theearn1/public_html/resources/views/team-leads.blade.php ENDPATH**/ ?>